/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.file.mapping;

import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.ph.phservice.collector.Context;
import com.vmware.ph.phservice.collector.cdf.mapping.Mapping;
import java.io.File;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetToFileMapping
implements Mapping<ResultSet, File> {
    private static final Log _log = LogFactory.getLog(ResultSetToFileMapping.class);
    private final String _filePropertyName;

    public ResultSetToFileMapping(String filePropertyName) {
        this._filePropertyName = filePropertyName;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)obj, (Object)this);
    }

    public String getFilePropertyName() {
        return this._filePropertyName;
    }

    @Override
    public File map(ResultSet input, Context context) {
        if (input == null) {
            return null;
        }
        File file = null;
        List resourceItems = input.getItems();
        if (!resourceItems.isEmpty()) {
            ResourceItem item = (ResourceItem)resourceItems.get(0);
            file = ResultSetToFileMapping.mapResourceItemToFile(item, this._filePropertyName);
        }
        return file;
    }

    private static File mapResourceItemToFile(ResourceItem item, String filePropertyName) {
        File file = null;
        try {
            file = (File)item.get(filePropertyName);
        }
        catch (IllegalArgumentException e) {
            _log.warn((Object)String.format("The result item does not contain property with name %s found in the 'filePropertyName' element.", filePropertyName), (Throwable)e);
        }
        return file;
    }
}

