/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.manifest.xml;

import com.vmware.ph.client.api.commondataformat20.Payload20;
import com.vmware.ph.phservice.CollectionPeriod;
import com.vmware.ph.phservice.collector.NamedQueryResultSetMapping;
import com.vmware.ph.phservice.collector.NoOpNamedQueryResultSetMapping;
import com.vmware.ph.phservice.collector.cdf.mapping.Mapping;
import com.vmware.ph.phservice.collector.data.NamedQuery;
import com.vmware.ph.phservice.collector.manifest.Manifest;
import com.vmware.ph.phservice.collector.manifest.ManifestProvider;
import com.vmware.ph.phservice.collector.manifest.xml.XmlManifestUtils;
import com.vmware.ph.phservice.collector.manifest.xml.mapping.JaxbCdfMappingParser;
import com.vmware.ph.phservice.collector.manifest.xml.mapping.MappingParser;
import com.vmware.ph.phservice.collector.manifest.xml.mapping.file.JaxbFileMappingParser;
import com.vmware.ph.phservice.collector.manifest.xml.query.JaxbRequestSpecParser;
import com.vmware.ph.phservice.collector.manifest.xml.query.QueryUtils;
import com.vmware.ph.phservice.collector.manifest.xml.query.RequestSpecParser;
import com.vmware.ph.phservice.collector.manifest.xml.query.data.RequestSpec;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class XmlManifestProvider
implements ManifestProvider {
    private static final Log _log = LogFactory.getLog(XmlManifestProvider.class);
    private static final int DEFAULT_PAGE_SIZE = 5000;
    private final String _manifestStr;
    private final CollectionPeriod _collectionPeriod;
    private final RequestSpecParser _requestParser;
    private final MappingParser _cdfMappingParser;
    private final MappingParser _fileMappingParser;

    public XmlManifestProvider(String manifestStr, CollectionPeriod collectionPeriod) {
        this(manifestStr, collectionPeriod, new JaxbRequestSpecParser(), new JaxbCdfMappingParser(), new JaxbFileMappingParser());
    }

    XmlManifestProvider(String manifestStr, CollectionPeriod collectionPeriod, RequestSpecParser requestSpecParser, MappingParser cdfMappingParser, MappingParser fileMappingParser) {
        this._manifestStr = manifestStr;
        this._collectionPeriod = collectionPeriod;
        this._requestParser = requestSpecParser;
        this._cdfMappingParser = cdfMappingParser;
        this._fileMappingParser = fileMappingParser;
    }

    @Override
    public Manifest getManifest() {
        Document manifestDoc = this._collectionPeriod.equals((Object)CollectionPeriod.DAILY) ? XmlManifestUtils.getDailySection(this._manifestStr) : XmlManifestUtils.getWeeklySection(this._manifestStr);
        if (manifestDoc == null) {
            _log.info((Object)String.format("Manifest section for %s period is empty.", new Object[]{this._collectionPeriod}));
            return null;
        }
        NamedQuery[] queries = XmlManifestProvider.parseQueries(manifestDoc, this._requestParser);
        NamedQueryResultSetMapping<Payload20> cdfNamedQueryMapping = XmlManifestProvider.getCdfNamedQueryMapping(manifestDoc, this._cdfMappingParser);
        NamedQueryResultSetMapping<File> fileNamedQueryMapping = XmlManifestProvider.getFileNamedQueryMapping(manifestDoc, this._fileMappingParser);
        int recommendedPageSize = XmlManifestUtils.getRecommendedPageSize(manifestDoc, 5000);
        Manifest result = new Manifest(queries, XmlManifestProvider.getNonNullNamedQueryResultSetMapping(cdfNamedQueryMapping), XmlManifestProvider.getNonNullNamedQueryResultSetMapping(fileNamedQueryMapping), recommendedPageSize);
        return result;
    }

    private static NamedQuery[] parseQueries(Document manifestDoc, RequestSpecParser requestParser) {
        RequestSpec request = XmlManifestUtils.parseRequestSpec(manifestDoc, requestParser);
        if (request.getQueries() == null) {
            return new NamedQuery[0];
        }
        NamedQuery[] queries = new NamedQuery[request.getQueries().size()];
        for (int i = 0; i < queries.length; ++i) {
            queries[i] = QueryUtils.viseQuerySpecToRiseQuery(request.getQueries().get(i));
        }
        return queries;
    }

    private static NamedQueryResultSetMapping<Payload20> getCdfNamedQueryMapping(Document manifestDoc, MappingParser cdfMappingParser) {
        Mapping cdfMapping = XmlManifestUtils.parseCdfMapping(manifestDoc, cdfMappingParser);
        NamedQueryResultSetMapping cdfNamedQueryMapping = (NamedQueryResultSetMapping)cdfMapping;
        return cdfNamedQueryMapping;
    }

    private static NamedQueryResultSetMapping<File> getFileNamedQueryMapping(Document manifestDoc, MappingParser fileMappingParser) {
        Mapping fileMapping = XmlManifestUtils.parseFileMapping(manifestDoc, fileMappingParser);
        NamedQueryResultSetMapping fileNamedQueryMapping = (NamedQueryResultSetMapping)fileMapping;
        return fileNamedQueryMapping;
    }

    private static <T> NamedQueryResultSetMapping<T> getNonNullNamedQueryResultSetMapping(NamedQueryResultSetMapping<T> resultSetMapping) {
        if (resultSetMapping == null) {
            return new NoOpNamedQueryResultSetMapping();
        }
        return resultSetMapping;
    }
}

