/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.manifest.xml;

import com.vmware.ph.phservice.collector.cdf.mapping.Mapping;
import com.vmware.ph.phservice.collector.manifest.InvalidManifestException;
import com.vmware.ph.phservice.collector.manifest.xml.mapping.MappingParser;
import com.vmware.ph.phservice.collector.manifest.xml.query.RequestSpecParser;
import com.vmware.ph.phservice.collector.manifest.xml.query.data.RequestSpec;
import com.vmware.ph.phservice.common.xml.XmlUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class XmlManifestUtils {
    private static final String REQUEST_ELEMENT_NAME = "request";
    private static final String MANIFEST_RECOMMENDED_PAGE_SIZE_ATTRIBUTE = "recommendedPageSize";
    private static final String CDF_MAPPING_ELEMENT_NAME = "cdfMapping";
    private static final String FILE_MAPPING_ELEMENT_NAME = "fileMapping";

    public static int getRecommendedPageSize(Document document, int defaultPageSize) {
        int pageSize;
        String pageSizeStr = XmlManifestUtils.getRecommendedPageSizeRawValue(document);
        if (!StringUtils.isEmpty((String)pageSizeStr)) {
            try {
                pageSize = Integer.parseInt(pageSizeStr);
            }
            catch (NumberFormatException e) {
                pageSize = defaultPageSize;
            }
        } else {
            pageSize = defaultPageSize;
        }
        return pageSize;
    }

    public static Document getDailySection(String manifest) {
        Document doc = XmlUtils.parseManifestToDoc(manifest);
        Element dailyNode = XmlUtils.findFirstDirectChildElement(doc, "daily");
        if (dailyNode != null) {
            String pageSizeRawValue = XmlManifestUtils.getRecommendedPageSizeRawValue(doc);
            if (StringUtils.isNotEmpty((String)pageSizeRawValue)) {
                dailyNode.setAttribute(MANIFEST_RECOMMENDED_PAGE_SIZE_ATTRIBUTE, pageSizeRawValue);
            }
            return XmlUtils.makeDocumentFromNode(dailyNode);
        }
        return null;
    }

    public static Document getWeeklySection(String manifest) {
        Document doc = XmlUtils.parseManifestToDoc(manifest);
        XmlUtils.removeAllLevelOneElements(doc, "daily");
        return doc;
    }

    public static <I, O> Mapping<I, O> parseCdfMapping(Document manifestDoc, MappingParser mappingParser) {
        return XmlManifestUtils.parseMapping(manifestDoc, mappingParser, CDF_MAPPING_ELEMENT_NAME, true);
    }

    public static <I, O> Mapping<I, O> parseFileMapping(Document manifestDoc, MappingParser mappingParser) {
        return XmlManifestUtils.parseMapping(manifestDoc, mappingParser, FILE_MAPPING_ELEMENT_NAME, false);
    }

    public static RequestSpec parseRequestSpec(Document manifestDoc, RequestSpecParser requestParser) {
        Element requestElement = XmlManifestUtils.getElement(manifestDoc, REQUEST_ELEMENT_NAME, true);
        RequestSpec requestSpec = requestParser.parse(requestElement);
        return requestSpec;
    }

    private static <I, O> Mapping<I, O> parseMapping(Document manifestDoc, MappingParser mappingParser, String mappingElementName, boolean isMappingRequired) {
        Element mappingElement = XmlManifestUtils.getElement(manifestDoc, mappingElementName, isMappingRequired);
        Mapping mapping = null;
        if (mappingElement != null) {
            mapping = mappingParser.parse(mappingElement);
        }
        return mapping;
    }

    private static Element getElement(Document manifestDoc, String elementName, boolean isElementRequired) {
        NodeList elements = manifestDoc.getElementsByTagNameNS("", elementName);
        if (elements.getLength() < 1 || elements.item(0).getNodeType() != 1) {
            if (isElementRequired) {
                throw new InvalidManifestException("Collection manifest is missing required element: " + elementName);
            }
            return null;
        }
        return (Element)elements.item(0);
    }

    private static String getRecommendedPageSizeRawValue(Document document) {
        return document.getDocumentElement().getAttributeNS(null, MANIFEST_RECOMMENDED_PAGE_SIZE_ATTRIBUTE);
    }
}

