/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.manifest.xml.mapping.file;

import com.vmware.ph.exceptions.Bug;
import com.vmware.ph.phservice.collector.cdf.mapping.Mapping;
import com.vmware.ph.phservice.collector.data.NamedQueryResultSet;
import com.vmware.ph.phservice.collector.manifest.InvalidManifestException;
import com.vmware.ph.phservice.collector.manifest.xml.mapping.MappingParser;
import com.vmware.ph.phservice.collector.manifest.xml.mapping.data.Mappings;
import com.vmware.ph.phservice.collector.manifest.xml.mapping.file.data.IndependentFileMappings;
import com.vmware.ph.phservice.collector.manifest.xml.mapping.file.data.ResultSetToFileMapping;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JaxbFileMappingParser
implements MappingParser {
    private static JAXBContext _instance;
    private final JAXBContext _ctx;
    private final Unmarshaller _parser;

    static JAXBContext getInstance() throws JAXBException {
        if (_instance == null) {
            _instance = JAXBContext.newInstance((Class[])new Class[]{IndependentFileMappings.class, ResultSetToFileMapping.class, Mappings.Wrapper.class});
        }
        return _instance;
    }

    public JaxbFileMappingParser() {
        try {
            this._ctx = JaxbFileMappingParser.getInstance();
            this._parser = this._ctx.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new Bug("Bad hardcoded JAXB configuration.", (Throwable)e);
        }
    }

    public Mapping parse(Node xmlNode) {
        try {
            Node element = this.getFirstChildElement(xmlNode);
            if (element == null) {
                com.vmware.ph.phservice.collector.file.mapping.IndependentFileMappings emptyMapping = IndependentFileMappings.EMPTY_FILE_MAPPING;
                return emptyMapping;
            }
            Object parsedObj = this._parser.unmarshal(element);
            if (!(parsedObj instanceof IndependentFileMappings)) {
                throw new InvalidManifestException("Unexpected fileMapping first child element in XML manifest.");
            }
            IndependentFileMappings result = (IndependentFileMappings)parsedObj;
            Mapping<NamedQueryResultSet, File> fileMapping = result.build();
            return fileMapping;
        }
        catch (JAXBException e) {
            throw new InvalidManifestException("Failed parsing mapping from XML.", e);
        }
    }

    private Node getFirstChildElement(Node xmlNode) {
        NodeList children = xmlNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            return children.item(i);
        }
        return null;
    }
}

