/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.product.impl;

import com.vmware.ph.phservice.collector.product.ProductCollectorExceptionHandler;
import com.vmware.ph.phservice.collector.product.ProductEndpoint;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CancelationProductCollectorExceptionHandlerImpl
implements ProductCollectorExceptionHandler {
    private static final Log _logger = LogFactory.getLog(CancelationProductCollectorExceptionHandlerImpl.class);
    private final ProductCollectorExceptionHandler _originalExceptionHandler;
    private final int _maxRetries;
    private Future<?> _collectorTask;
    private AtomicInteger retries = new AtomicInteger(0);

    public CancelationProductCollectorExceptionHandlerImpl(ProductCollectorExceptionHandler exceptionHandler, int maxRetries) {
        Validate.isTrue((maxRetries >= 0 ? 1 : 0) != 0, (String)"maxRetries must be a positive integer including zero");
        this._originalExceptionHandler = exceptionHandler;
        this._maxRetries = maxRetries;
    }

    public CancelationProductCollectorExceptionHandlerImpl(int maxRetries) {
        this(null, maxRetries);
    }

    @Override
    public void handleException(ProductEndpoint endpoint, Exception e) {
        if (this._originalExceptionHandler != null) {
            this._originalExceptionHandler.handleException(endpoint, e);
        }
        if (this._collectorTask != null && this.retries.incrementAndGet() >= this._maxRetries) {
            this._collectorTask.cancel(true);
            _logger.warn((Object)String.format("Scheduled future for endpoint '%s' was canceled after maximum number of reties='%d' was hit", endpoint, this._maxRetries));
        }
    }

    @Override
    public void setCollectorTask(Future<?> collectorTask) {
        Validate.notNull(collectorTask, (String)"The future object cannot be null");
        if (this._originalExceptionHandler != null) {
            this._originalExceptionHandler.setCollectorTask(collectorTask);
        }
        this._collectorTask = collectorTask;
    }
}

