/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.scheduler;

import com.vmware.ph.phservice.CollectionPeriod;
import com.vmware.ph.phservice.collector.scheduler.ConfigurationException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.TimeZone;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class ScheduleCalculator {
    private final Random rnd = new Random();

    public boolean isItTimeToFire(CollectionPeriod collectionPeriod, long lastFired, long now, String schedule) {
        boolean weekly = CollectionPeriod.WEEKLY.equals((Object)collectionPeriod);
        if (lastFired < 0L || now < 0L || now < lastFired) {
            return true;
        }
        Calendar cNextFire = this.getNextFireTime(lastFired, schedule, weekly);
        assert (lastFired < cNextFire.getTimeInMillis());
        Calendar cNow = this.buildCalendarInTheRightTimezone(now);
        boolean res = cNextFire.before(cNow);
        return res;
    }

    private Calendar getNextFireTime(long now, String schedule, boolean weekly) {
        long fastForward = 60000L - now % 60000L;
        assert (0L == (now += fastForward) % 60000L);
        Calendar cNow = this.buildCalendarInTheRightTimezone(now);
        Calendar cSchedule = this.validateScheduleAndBuildCalendar(schedule, true);
        this.increaseUntilTheyMatch(cNow, 12, cSchedule, 59);
        this.increaseUntilTheyMatch(cNow, 11, cSchedule, 23);
        if (weekly) {
            this.increaseUntilTheyMatch(cNow, 7, cSchedule, 6);
        }
        return cNow;
    }

    private void increaseUntilTheyMatch(Calendar toBeIncreased, int field, Calendar target, int maxIncreaseSteps) {
        int v2;
        int v1;
        for (int i = 0; i <= maxIncreaseSteps && (v1 = toBeIncreased.get(field)) != (v2 = target.get(field)); ++i) {
            toBeIncreased.add(field, 1);
        }
    }

    private Calendar buildCalendarInTheRightTimezone(long now) {
        GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        c.setTimeInMillis(now);
        return c;
    }

    public Calendar validateScheduleAndBuildCalendar(String schedule, boolean onErrorThrow) {
        boolean isValid;
        String[] values = StringUtils.split((String)schedule, (String)" ");
        int numArgs = ArrayUtils.getLength((Object)values);
        if (numArgs < 3) {
            return onErrorThrow ? this.invalidSchedule(schedule, null) : null;
        }
        Calendar calendar = null;
        NumberFormatException errorCause = null;
        try {
            String sMinute = values[numArgs - 1];
            String sHour = values[numArgs - 2];
            String sDayOfWeek = values[numArgs - 3];
            int minute = Integer.parseInt(sMinute);
            int hour = Integer.parseInt(sHour);
            int dayOfWeek = Integer.parseInt(sDayOfWeek);
            boolean bl = isValid = 0 <= minute && minute <= 59 && 0 <= hour && hour <= 23 && 0 <= dayOfWeek && dayOfWeek <= 6;
            if (isValid) {
                calendar = this.buildCalendarInTheRightTimezone(0L);
                calendar.set(7, dayOfWeek + 1);
                calendar.set(11, hour);
                calendar.set(12, minute);
                calendar.set(14, 0);
                calendar.clear(14);
            }
        }
        catch (NumberFormatException e) {
            calendar = null;
            isValid = false;
            errorCause = e;
        }
        return onErrorThrow && !isValid ? this.invalidSchedule(schedule, errorCause) : calendar;
    }

    public String generateRandomSchedule() {
        int minute = this.rnd.nextInt(60);
        int hour = this.rnd.nextInt(24);
        int dayOfWeek = this.rnd.nextInt(7);
        return dayOfWeek + " " + hour + " " + minute;
    }

    private Calendar invalidSchedule(String schedule, Throwable cause) {
        throw new ConfigurationException("Provided schedule is invalid: " + schedule, cause);
    }
}

