/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.scheduler.impl;

import com.vmware.ph.phservice.collector.scheduler.CollectorLoopExecutionConfigProvider;
import com.vmware.ph.phservice.common.ConfigurationService;
import java.util.concurrent.TimeUnit;

public class CollectorLoopExecutionConfigProviderImpl
implements CollectorLoopExecutionConfigProvider {
    private static final long DEFAULT_INIT_BACKOFF_TIME_SECONDS = TimeUnit.MINUTES.toSeconds(5L);
    private static final long DEFAULT_BACKOFF_TIME_ONERROR_SECONDS = TimeUnit.HOURS.toSeconds(2L);
    private static final long DEFAULT_SCHEDULE_CHECK_TIME_SECONDS = TimeUnit.HOURS.toSeconds(1L);
    private final ConfigurationService _configurationService;
    private final String _propNameForInitBackOffTime;
    private final String _propNameForScheduleCheckTime;
    private final String _propNameForBackOffTimeOnError;
    private final String _propNameForRunCollectorOnce;

    public CollectorLoopExecutionConfigProviderImpl(ConfigurationService configurationService, String propNameForInitBackOffTime, String propNameForScheduleCheckTime, String propNameForBackOffTimeOnError, String propNameForRunCollectorOnce) {
        this._configurationService = configurationService;
        this._propNameForInitBackOffTime = propNameForInitBackOffTime;
        this._propNameForScheduleCheckTime = propNameForScheduleCheckTime;
        this._propNameForBackOffTimeOnError = propNameForBackOffTimeOnError;
        this._propNameForRunCollectorOnce = propNameForRunCollectorOnce;
    }

    @Override
    public long getInitialBackOffTimeSeconds() {
        return this.getLongValue(this._propNameForInitBackOffTime, DEFAULT_INIT_BACKOFF_TIME_SECONDS);
    }

    @Override
    public long getBackoffTimeSeconds() {
        return this.getLongValue(this._propNameForBackOffTimeOnError, DEFAULT_BACKOFF_TIME_ONERROR_SECONDS);
    }

    @Override
    public long getScheduleCheckTimeSeconds() {
        return this.getLongValue(this._propNameForScheduleCheckTime, DEFAULT_SCHEDULE_CHECK_TIME_SECONDS);
    }

    @Override
    public boolean shouldRunOnce() {
        Boolean rawValue = this._configurationService.getBoolProperty(this._propNameForRunCollectorOnce);
        return rawValue == null ? false : rawValue;
    }

    private long getLongValue(String propertyName, long defaultValue) {
        Long value = this._configurationService.getLongProperty(propertyName);
        return value == null ? defaultValue : value;
    }
}

