/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.scheduler.impl;

import com.vmware.ph.phservice.CollectionPeriod;
import com.vmware.ph.phservice.collector.scheduler.CollectorActionCoordinator;
import com.vmware.ph.phservice.collector.scheduler.CollectorActionExecutionTracker;
import com.vmware.ph.phservice.collector.scheduler.ConfigurationException;
import com.vmware.ph.phservice.collector.scheduler.ScheduleCalculator;
import com.vmware.ph.phservice.collector.scheduler.ScheduleTracker;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultCollectorActionCoordinator
implements CollectorActionCoordinator {
    private static final Log _log = LogFactory.getLog(DefaultCollectorActionCoordinator.class);
    private final CollectorActionExecutionTracker _collectorActionExecutionTracker;
    private final ScheduleTracker _scheduleTracker;
    private final ScheduleCalculator _scheduleCalculator;
    private final SimpleDateFormat _formatter;

    public DefaultCollectorActionCoordinator(CollectorActionExecutionTracker collectorActionExecutionTracker, ScheduleTracker scheduleTracker) {
        this(collectorActionExecutionTracker, scheduleTracker, new ScheduleCalculator());
    }

    public DefaultCollectorActionCoordinator(CollectorActionExecutionTracker collectionExecutionTracker, ScheduleTracker scheduleTracker, ScheduleCalculator scheduleCalculator) {
        this._collectorActionExecutionTracker = collectionExecutionTracker;
        this._scheduleTracker = scheduleTracker;
        this._scheduleCalculator = scheduleCalculator;
        this._formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this._formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public void recordFirstBootTime(long firstBootTime) {
        block4: {
            try {
                if (this._collectorActionExecutionTracker.getLastCollectionTime(CollectionPeriod.DAILY) == 0L) {
                    this._collectorActionExecutionTracker.setLastCollectionTime(CollectionPeriod.DAILY, firstBootTime);
                }
                if (this._collectorActionExecutionTracker.getLastCollectionTime(CollectionPeriod.WEEKLY) == 0L) {
                    this._collectorActionExecutionTracker.setLastCollectionTime(CollectionPeriod.WEEKLY, firstBootTime);
                }
            }
            catch (Exception e) {
                if (!_log.isErrorEnabled()) break block4;
                _log.error((Object)"Error reading/writing lastCollectionTime during startup.", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isItTimeToFire(CollectionPeriod period) {
        String schedule = this.retrieveValidSchedule();
        long lastCollectionTime = this._collectorActionExecutionTracker.getLastCollectionTime(period);
        long now = System.currentTimeMillis();
        boolean timeToFire = this._scheduleCalculator.isItTimeToFire(period, lastCollectionTime, now, schedule);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Collector " + (Object)((Object)period) + " configuration: timeToFire = " + timeToFire + " ; schedule =  " + schedule + " ; lastCollectionTime = " + this.toUtcTimeString(lastCollectionTime) + " ; now = " + this.toUtcTimeString(now)));
        }
        return timeToFire;
    }

    @Override
    public void setLastCollectionTime(CollectionPeriod period, long currentTimeMillis) {
        this._collectorActionExecutionTracker.setLastCollectionTime(period, currentTimeMillis);
    }

    private String retrieveValidSchedule() throws ConfigurationException {
        String schedule = this._scheduleTracker.getSchedule();
        boolean isScheduleValid = true;
        if (StringUtils.isEmpty((String)schedule)) {
            isScheduleValid = false;
        } else {
            Calendar scheduleCalendar = this._scheduleCalculator.validateScheduleAndBuildCalendar(schedule, false);
            if (scheduleCalendar == null) {
                isScheduleValid = false;
            }
        }
        if (!isScheduleValid) {
            String newSchedule = this._scheduleCalculator.generateRandomSchedule();
            this._scheduleTracker.setSchedule(newSchedule);
            schedule = newSchedule;
            if (_log.isInfoEnabled()) {
                _log.info((Object)String.format("The data collection was enabled but the configured schedule `%s' was not valid. Created new schedule: %s", schedule, newSchedule));
            }
        }
        return schedule;
    }

    private String toUtcTimeString(long timeInMillis) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(timeInMillis);
        return this._formatter.format(calendar.getTime());
    }
}

