/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.scheduler.impl;

import com.vmware.ph.phservice.CollectionPeriod;
import com.vmware.ph.phservice.collector.scheduler.CollectorActionCoordinator;
import com.vmware.ph.phservice.common.ConfigurationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ForcingCollectorActionCoordinator
implements CollectorActionCoordinator {
    private static final Log _log = LogFactory.getLog(ForcingCollectorActionCoordinator.class);
    private final CollectorActionCoordinator _wrappedCollectorActionCoordinator;
    private final ConfigurationService _configurationService;
    private final String _propNameForForceCollectAlways;

    public ForcingCollectorActionCoordinator(CollectorActionCoordinator collectorActionCoordinator, ConfigurationService configurationService, String propNameForForceCollectAlways) {
        this._wrappedCollectorActionCoordinator = collectorActionCoordinator;
        this._configurationService = configurationService;
        this._propNameForForceCollectAlways = propNameForForceCollectAlways;
    }

    @Override
    public void recordFirstBootTime(long firstBootTime) {
        this._wrappedCollectorActionCoordinator.recordFirstBootTime(firstBootTime);
    }

    @Override
    public boolean isItTimeToFire(CollectionPeriod period) {
        boolean forcedCollection;
        boolean isItTimeToFire = this._wrappedCollectorActionCoordinator.isItTimeToFire(period);
        Boolean rawValue = this._configurationService.getBoolProperty(this._propNameForForceCollectAlways);
        boolean bl = forcedCollection = rawValue == null ? false : rawValue;
        if (forcedCollection && _log.isInfoEnabled()) {
            _log.info((Object)"Collection will happen, becasue it is forced via configuration.");
        }
        return forcedCollection || isItTimeToFire;
    }

    @Override
    public void setLastCollectionTime(CollectionPeriod period, long currentTimeMillis) {
        this._wrappedCollectorActionCoordinator.setLastCollectionTime(period, currentTimeMillis);
    }
}

