/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.scheduler.impl;

import com.vmware.ph.phservice.collector.scheduler.ScheduleTracker;
import com.vmware.ph.phservice.common.PersistenceService;
import com.vmware.ph.phservice.common.PersistenceServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScheduleTrackerImpl
implements ScheduleTracker {
    private static final Log _log = LogFactory.getLog(ScheduleTrackerImpl.class);
    private static final String KEY_PHSERVICES_COLLECTION_SCHEDULE = "phservices.collection.schedule";
    private final PersistenceService _persistenceService;

    public ScheduleTrackerImpl(PersistenceService persistenceService) {
        this._persistenceService = persistenceService;
    }

    @Override
    public String getSchedule() {
        try {
            return this._persistenceService.readString(KEY_PHSERVICES_COLLECTION_SCHEDULE);
        }
        catch (PersistenceServiceException e) {
            _log.error((Object)"An exception occurred while trying to retrieve schedule.", (Throwable)e);
            return null;
        }
    }

    @Override
    public void setSchedule(String newSchedule) {
        try {
            this._persistenceService.writeString(KEY_PHSERVICES_COLLECTION_SCHEDULE, newSchedule);
        }
        catch (PersistenceServiceException e) {
            _log.error((Object)"An exception occurred while trying to write schedule.", (Throwable)e);
        }
    }
}

