/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.vcenter;

import com.vmware.af.VmAfClient;
import com.vmware.ph.phservice.ciscommon.CisContext;
import com.vmware.ph.phservice.ciscommon.CisContextBuilder;
import com.vmware.ph.phservice.ciscommon.CisContextProvider;
import com.vmware.ph.phservice.ciscommon.KeyStoreProvider;
import java.net.URI;
import java.security.KeyStore;

public class AfdCisContextProvider
implements CisContextProvider {
    private final KeyStoreProvider _trustedKeyStoreProvider;
    private final KeyStoreProvider _solutionUserKeyStoreProvider;
    private final String _solutionUserEntryAlias;
    private VmAfClient _vmAfClient;

    public AfdCisContextProvider(KeyStoreProvider trustedKeyStoreProvider, KeyStoreProvider solutionUserKeyStoreProvider, String solutionUserEntryAlias) {
        this._trustedKeyStoreProvider = trustedKeyStoreProvider;
        this._solutionUserKeyStoreProvider = solutionUserKeyStoreProvider;
        this._solutionUserEntryAlias = solutionUserEntryAlias;
    }

    @Override
    public CisContext getCisContext() {
        VmAfClient vmAfClient = this.getVmAfClient();
        URI lookupServiceSdkUri = URI.create(vmAfClient.getLSLocation());
        KeyStore trustedKeyStore = this._trustedKeyStoreProvider.getKeyStore();
        KeyStore solutionUserKeyStore = this._solutionUserKeyStoreProvider.getKeyStore();
        CisContext cisContext = CisContextBuilder.forCis(lookupServiceSdkUri, trustedKeyStore).withSsoSolutionUser(solutionUserKeyStore, this._solutionUserEntryAlias, null).build();
        return cisContext;
    }

    private synchronized VmAfClient getVmAfClient() {
        if (this._vmAfClient == null) {
            this._vmAfClient = new VmAfClient("localhost");
        }
        return this._vmAfClient;
    }
}

