/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.vcenter;

import com.vmware.ph.common.net.ProxySettingsProvider;
import com.vmware.ph.config.ceip.CeipConfigProvider;
import com.vmware.ph.phservice.CollectionPeriod;
import com.vmware.ph.phservice.PayloadAuditPersisterProvider;
import com.vmware.ph.phservice.collector.core.Collector;
import com.vmware.ph.phservice.collector.core.CollectorProvider;
import com.vmware.ph.phservice.collector.core.impl.CollectorImpl;
import com.vmware.ph.phservice.collector.vcenter.VcenterTelemetryDataProvidersConnection;
import com.vmware.ph.phservice.common.ConfigurationService;
import com.vmware.ph.phservice.common.cdf.ManifestContentProvider;
import com.vmware.ph.phservice.common.cdf.PayloadUploader;
import com.vmware.ph.phservice.provider.common.DataProvidersConnection;
import com.vmware.ph.phservice.provider.vimcommon.VimContext;
import com.vmware.ph.phservice.provider.vimcommon.VimContextProvider;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcenterTelemetryCollectorProvider
implements CollectorProvider {
    private static final Log _log = LogFactory.getLog(VcenterTelemetryCollectorProvider.class);
    private final VimContextProvider _readOnlyVimContextProvider;
    private final VimContextProvider _nonReadOnlyVimContextProvider;
    private final CeipConfigProvider _ceipConfigProvider;
    private final ProxySettingsProvider _proxySettingsProvider;
    private final PayloadAuditPersisterProvider _payloadAuditPersisterProvider;
    private final ConfigurationService _configurationService;
    private final String _propNameForCollectorId;
    private final String _propNameForCollectorInstanceId;
    private final String _propNameForTargetVacEnvironment;
    private final String _propNameForManifestFileLocation;
    private final String _propNameForTargetPayloadDirectory;

    public VcenterTelemetryCollectorProvider(VimContextProvider readOnlyVimContextProvider, VimContextProvider nonReadOnlyVimContextProvider, CeipConfigProvider ceipConfigProvider, ProxySettingsProvider proxySettingsProvider, PayloadAuditPersisterProvider payloadAuditPersisterProvider, ConfigurationService configurationService, String propNameForCollectorId, String propNameForCollectorInstanceId, String propNameForTargetVacEnvironment, String propNameForManifestFileLocation, String propNameForTargetPayloadDirectory) {
        this._readOnlyVimContextProvider = readOnlyVimContextProvider;
        this._nonReadOnlyVimContextProvider = nonReadOnlyVimContextProvider;
        this._ceipConfigProvider = ceipConfigProvider;
        this._proxySettingsProvider = proxySettingsProvider;
        this._payloadAuditPersisterProvider = payloadAuditPersisterProvider;
        this._configurationService = configurationService;
        this._propNameForCollectorId = propNameForCollectorId;
        this._propNameForCollectorInstanceId = propNameForCollectorInstanceId;
        this._propNameForTargetVacEnvironment = propNameForTargetVacEnvironment;
        this._propNameForManifestFileLocation = propNameForManifestFileLocation;
        this._propNameForTargetPayloadDirectory = propNameForTargetPayloadDirectory;
    }

    @Override
    public Collector getCollector(CollectionPeriod collectionPeriod) {
        boolean collectorEnabled;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Retrieve the CEIP status.");
        }
        if (!(collectorEnabled = this._ceipConfigProvider.isCeipEnabled())) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Skipping collection because usage data collector is not enabled.");
            }
            return null;
        }
        VimContext vimContextWithReadOnlyUser = this._readOnlyVimContextProvider.getVimContext();
        VimContext vimContextWithNonReadOnlyUser = this._nonReadOnlyVimContextProvider.getVimContext();
        if (vimContextWithReadOnlyUser == null || vimContextWithNonReadOnlyUser == null) {
            _log.debug((Object)"Missing VimContext. No DataProvider-s will be created.");
            return null;
        }
        VcenterTelemetryDataProvidersConnection dataProvidersConnection = new VcenterTelemetryDataProvidersConnection(vimContextWithReadOnlyUser, vimContextWithNonReadOnlyUser);
        Properties properties = this.prepareCollectionProperties();
        CollectorImpl collector = new CollectorImpl(dataProvidersConnection, null, null, this._payloadAuditPersisterProvider, this._proxySettingsProvider, properties, dataProvidersConnection.getReadOnlyVcClientProvider(), collectionPeriod);
        return new CollectorConnectionClosingWrapper(collector, dataProvidersConnection);
    }

    @Override
    public Collector getCollector(String collectorId, String collectorInstanceId, ManifestContentProvider manifestContentProvider, PayloadUploader payloadUploader, CollectionPeriod collectionPeriod) {
        boolean collectorEnabled;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Retrieve the CEIP status.");
        }
        if (!(collectorEnabled = this._ceipConfigProvider.isCeipEnabled())) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Skipping collection because usage data collector is not enabled.");
            }
            return null;
        }
        VimContext vimContextWithReadOnlyUser = this._readOnlyVimContextProvider.getVimContext();
        VimContext vimContextWithNonReadOnlyUser = this._nonReadOnlyVimContextProvider.getVimContext();
        if (vimContextWithReadOnlyUser == null || vimContextWithNonReadOnlyUser == null) {
            _log.debug((Object)"Missing VimContext. No DataProvider-s will be created.");
            return null;
        }
        VcenterTelemetryDataProvidersConnection dataProvidersConnection = new VcenterTelemetryDataProvidersConnection(vimContextWithReadOnlyUser, vimContextWithNonReadOnlyUser);
        Properties properties = new Properties();
        properties.setProperty("cmc.collector_id", collectorId);
        properties.setProperty("cmc.instance_id", collectorInstanceId);
        CollectorImpl collector = new CollectorImpl(dataProvidersConnection, manifestContentProvider, payloadUploader, null, null, properties, dataProvidersConnection.getReadOnlyVcClientProvider(), collectionPeriod);
        return new CollectorConnectionClosingWrapper(collector, dataProvidersConnection);
    }

    private Properties prepareCollectionProperties() {
        Properties properties = new Properties();
        this.prepareOldProperty(properties, this._propNameForCollectorId, "cmc.collector_id");
        this.prepareOldProperty(properties, this._propNameForCollectorInstanceId, "cmc.instance_id");
        this.prepareOldProperty(properties, this._propNameForTargetVacEnvironment, "cmc.target_environment");
        this.prepareOldProperty(properties, this._propNameForManifestFileLocation, "cmc.manifest_location");
        this.prepareOldProperty(properties, this._propNameForTargetPayloadDirectory, "cmc.target_payload_location");
        return properties;
    }

    private void prepareOldProperty(Properties properties, String newPropertyName, String oldPropertyName) {
        String value = this._configurationService.getProperty(newPropertyName);
        if (value != null) {
            properties.setProperty(oldPropertyName, value);
        }
    }

    private static class CollectorConnectionClosingWrapper
    implements Collector {
        private final Collector _wrappedCollector;
        private final DataProvidersConnection _dataProvidersConnection;

        public CollectorConnectionClosingWrapper(Collector wrappedCollector, DataProvidersConnection dataProvidersConnection) {
            this._wrappedCollector = wrappedCollector;
            this._dataProvidersConnection = dataProvidersConnection;
        }

        @Override
        public void run() {
            this._wrappedCollector.run();
        }

        @Override
        public void close() {
            this._wrappedCollector.close();
            this._dataProvidersConnection.close();
        }
    }
}

