/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.common.cache;

import com.vmware.ph.phservice.common.cache.Cache;
import com.vmware.ph.phservice.common.cache.CacheInvalidateCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FifoCacheImpl<K, V>
implements Cache<K, V> {
    private final ReentrantReadWriteLock _rwLock = new ReentrantReadWriteLock();
    private final Lock _readLock = this._rwLock.readLock();
    private final Lock _writeLock = this._rwLock.writeLock();
    private final FifoTable<K, V> _table;
    private final CacheInvalidateCallback<V> _invalidateCallback;

    public FifoCacheImpl(int capacity) {
        this(capacity, null);
    }

    public FifoCacheImpl(int capacity, CacheInvalidateCallback<V> invalidateCallback) {
        this._table = new FifoTable(capacity);
        this._invalidateCallback = invalidateCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value) {
        this._writeLock.lock();
        try {
            this._table.put(key, value);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        this._readLock.lock();
        try {
            Object v = this._table.get(key);
            return v;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<K> getAllKeys() {
        this._readLock.lock();
        try {
            Set set = this._table.keySet();
            return set;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(K key) {
        this._readLock.lock();
        try {
            boolean bl = this._table.containsKey(key);
            return bl;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(K key) {
        Object value = null;
        this._writeLock.lock();
        try {
            value = this._table.remove(key);
        }
        finally {
            this._writeLock.unlock();
        }
        if (this._invalidateCallback != null && value != null) {
            this._invalidateCallback.cacheValueInvalidated(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        ArrayList valuesCopy = null;
        this._writeLock.lock();
        try {
            if (this._invalidateCallback != null) {
                valuesCopy = new ArrayList(this._table.values());
            }
            this._table.clear();
        }
        finally {
            this._writeLock.unlock();
        }
        if (this._invalidateCallback != null && valuesCopy != null) {
            for (Object value : valuesCopy) {
                this._invalidateCallback.cacheValueInvalidated(value);
            }
        }
    }

    private static class FifoTable<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int _capacity;

        public FifoTable(int capacity) {
            super(capacity + 1, 0.75f, false);
            this._capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this._capacity;
        }
    }
}

