/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.common.cache;

import com.vmware.ph.phservice.common.cache.Cache;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LruCacheImpl<K, V>
implements Cache<K, V> {
    private final ReentrantReadWriteLock _rwLock = new ReentrantReadWriteLock();
    private final Lock _readLock = this._rwLock.readLock();
    private final Lock _writeLock = this._rwLock.writeLock();
    private final LruTable<K, V> _table;

    public LruCacheImpl(int capacity) {
        this._table = new LruTable(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value) {
        this._writeLock.lock();
        try {
            this._table.put(key, value);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        this._readLock.lock();
        try {
            Object v = this._table.get(key);
            return v;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<K> getAllKeys() {
        this._readLock.lock();
        try {
            Set set = this._table.keySet();
            return set;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(K key) {
        this._readLock.lock();
        try {
            boolean bl = this._table.containsKey(key);
            return bl;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(K key) {
        this._writeLock.lock();
        try {
            this._table.remove(key);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        this._writeLock.lock();
        try {
            this._table.clear();
        }
        finally {
            this._writeLock.unlock();
        }
    }

    static class LruTable<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int _capacity;

        public LruTable(int capacity) {
            super(capacity + 1, 0.75f, true);
            this._capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this._capacity;
        }
    }
}

