/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.common.cache;

import com.vmware.ph.phservice.common.cache.Cache;
import com.vmware.ph.phservice.common.cache.CacheInvalidateCallback;
import com.vmware.ph.phservice.common.cache.LruCacheImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SimpleTimeBasedCacheImpl<K, V>
implements Cache<K, V> {
    private final ReentrantReadWriteLock _rwLock = new ReentrantReadWriteLock();
    private final Lock _readLock = this._rwLock.readLock();
    private final Lock _writeLock = this._rwLock.writeLock();
    private final long _expirationIntervalMs;
    private final Map<K, V> _table;
    private final CacheInvalidateCallback<V> _invalidateCallback;
    private Date _lastCacheInvalidation;

    public SimpleTimeBasedCacheImpl(long expirationIntervalMs, int capacity) {
        this(expirationIntervalMs, capacity, null);
    }

    public SimpleTimeBasedCacheImpl(long expirationIntervalMs, int capacity, CacheInvalidateCallback<V> invalidateCallback) {
        this._expirationIntervalMs = expirationIntervalMs;
        this._table = new LruCacheImpl.LruTable(capacity);
        this._invalidateCallback = invalidateCallback;
        this._lastCacheInvalidation = new Date();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value) {
        this.invalidateCacheIfExpired();
        this._writeLock.lock();
        try {
            this._table.put(key, value);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        this.invalidateCacheIfExpired();
        this._readLock.lock();
        try {
            V v = this._table.get(key);
            return v;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<K> getAllKeys() {
        this._readLock.lock();
        try {
            Set<K> set = this._table.keySet();
            return set;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(K key) {
        this.invalidateCacheIfExpired();
        this._readLock.lock();
        try {
            boolean bl = this._table.containsKey(key);
            return bl;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(K key) {
        this.invalidateCacheIfExpired();
        Object value = null;
        this._writeLock.lock();
        try {
            value = this._table.remove(key);
        }
        finally {
            this._writeLock.unlock();
        }
        if (this._invalidateCallback != null && value != null) {
            this._invalidateCallback.cacheValueInvalidated(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        ArrayList<V> valuesCopy = null;
        this._writeLock.lock();
        try {
            if (this._invalidateCallback != null) {
                valuesCopy = new ArrayList<V>(this._table.values());
            }
            this._table.clear();
            this._lastCacheInvalidation = new Date();
        }
        finally {
            this._writeLock.unlock();
        }
        if (this._invalidateCallback != null && valuesCopy != null) {
            for (V value : valuesCopy) {
                this._invalidateCallback.cacheValueInvalidated(value);
            }
        }
    }

    private void invalidateCacheIfExpired() {
        if (this.isCacheExpired()) {
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCacheExpired() {
        this._readLock.lock();
        try {
            Date cacheExpirationTime = new Date(this._lastCacheInvalidation.getTime() + this._expirationIntervalMs);
            Date now = new Date();
            boolean bl = now.after(cacheExpirationTime);
            return bl;
        }
        finally {
            this._readLock.unlock();
        }
    }
}

