/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.common.cdf;

import com.vmware.ph.client.api.commondataformat.types.Resource;
import com.vmware.ph.client.api.commondataformat.types.nontoplevel.AnyPrimitive;
import java.util.ArrayList;
import java.util.Map;

public class CdfUtil {
    private CdfUtil() {
    }

    public static Resource.KeyValue[] convertMapToKeyValueArray(Map<String, Object> map) {
        ArrayList<Resource.KeyValue> keyValues = new ArrayList<Resource.KeyValue>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            AnyPrimitive value = CdfUtil.convertObjectToAnyPrimitive(entry.getValue());
            keyValues.add(new Resource.KeyValue(key, value));
        }
        return keyValues.toArray(new Resource.KeyValue[keyValues.size()]);
    }

    public static AnyPrimitive[] convertObjectArrayToAnyPrimitiveArray(Object[] objectArray) {
        AnyPrimitive[] anyPrimitiveArray = new AnyPrimitive[objectArray.length];
        for (int i = 0; i < anyPrimitiveArray.length; ++i) {
            Object objectValue = objectArray[i];
            anyPrimitiveArray[i] = CdfUtil.convertObjectToAnyPrimitive(objectValue);
        }
        return anyPrimitiveArray;
    }

    public static AnyPrimitive convertObjectToAnyPrimitive(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Double || obj instanceof Float) {
            return new AnyPrimitive(Double.valueOf(((Number)obj).doubleValue()));
        }
        if (obj instanceof Integer) {
            return new AnyPrimitive(Integer.valueOf((Integer)obj));
        }
        if (obj instanceof Long) {
            return new AnyPrimitive(Long.valueOf((Long)obj));
        }
        if (obj instanceof Boolean) {
            return new AnyPrimitive((Boolean)obj);
        }
        if (obj instanceof String) {
            return new AnyPrimitive((String)obj);
        }
        return new AnyPrimitive(obj.toString());
    }
}

