/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.common.ph;

import com.vmware.ph.client.api.impl.PhClientBuilder;
import com.vmware.ph.common.net.HttpConnectionConfig;
import com.vmware.ph.common.net.ProxySettings;
import com.vmware.ph.common.net.ProxySettingsProvider;
import com.vmware.ph.config.ceip.CeipConfigProvider;
import com.vmware.ph.upload.HttpClientSetup;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public abstract class BasePhRestClient
implements AutoCloseable {
    private static final String PH_HOST = "vcsa.vmware.com";
    private static final Log _log = LogFactory.getLog(BasePhRestClient.class);
    private static final int MAX_CONNECTIONS_TOTAL = 30;
    private static final int MAX_CONNECTIONS_PER_ROUTE = 10;
    private static final int CONNECTION_TIMEOUT = 60000;
    private final PhClientBuilder.Environment _environment;
    private final CeipConfigProvider _ceipConfigProvider;
    protected final CloseableHttpClient _httpClient;

    public BasePhRestClient(PhClientBuilder.Environment environment, ProxySettingsProvider proxySettingsProvider, CeipConfigProvider ceipConfigProvider) {
        this(environment, BasePhRestClient.buildHttpClient(proxySettingsProvider), ceipConfigProvider);
    }

    BasePhRestClient(PhClientBuilder.Environment environment, CloseableHttpClient httpClient, CeipConfigProvider ceipConfigProvider) {
        this._environment = Objects.requireNonNull(environment);
        this._httpClient = httpClient;
        this._ceipConfigProvider = Objects.requireNonNull(ceipConfigProvider);
    }

    @Override
    public void close() {
        try {
            this._httpClient.close();
        }
        catch (IOException e) {
            _log.debug((Object)"Failed to close HTTP client.", (Throwable)e);
        }
    }

    protected boolean isCeipEnabled() {
        return this._ceipConfigProvider.isCeipEnabled();
    }

    protected boolean isProd() {
        return this._environment == PhClientBuilder.Environment.PRODUCTION;
    }

    protected static URI createPhSendUri(String urlPath, String collectorId, String collectorInstanceId, String version, Map<String, String> additionalUrlParams) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder().setScheme("https").setHost(PH_HOST).setPath(urlPath).setParameter("_c", collectorId);
        if (version != null) {
            uriBuilder.setParameter("_v", version);
        }
        if (collectorInstanceId != null) {
            uriBuilder.setParameter("_i", collectorInstanceId);
        }
        if (additionalUrlParams != null) {
            for (Map.Entry<String, String> entry : additionalUrlParams.entrySet()) {
                uriBuilder.addParameter(entry.getKey(), entry.getValue());
            }
        }
        URI uri = uriBuilder.build();
        return uri;
    }

    protected static URI createObjectQueryUri(String urlPath, String collectorId, String collectorInstanceId, String dataType, String objectId) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder().setScheme("https").setHost(PH_HOST).setPath(urlPath);
        uriBuilder.setParameter("collectorId", collectorId);
        if (collectorInstanceId != null) {
            uriBuilder.setParameter("deploymentId", collectorInstanceId);
        }
        uriBuilder.setParameter("type", dataType);
        if (objectId != null) {
            uriBuilder.setParameter("objectId", objectId);
        }
        URI uri = uriBuilder.build();
        return uri;
    }

    private static CloseableHttpClient buildHttpClient(ProxySettingsProvider proxySettingsProvider) {
        HttpConnectionConfig httpConnectionConfig = new HttpConnectionConfig(10, 30, 60000, null);
        ProxySettings proxySettings = proxySettingsProvider != null ? proxySettingsProvider.getProxySettings(httpConnectionConfig) : null;
        HttpClientBuilder httpClientBuilder = HttpClientSetup.createHttpClientBuilder((HttpConnectionConfig)httpConnectionConfig, (ProxySettings)proxySettings, (CredentialsProvider)new BasicCredentialsProvider());
        return httpClientBuilder.build();
    }
}

