/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.common.ph;

import com.vmware.ph.client.api.PhClient;
import com.vmware.ph.client.api.commondataformat.dimensions.Collector;
import com.vmware.ph.client.api.impl.PhClientBuilder;
import com.vmware.ph.common.net.ProxySettingsProvider;
import com.vmware.ph.config.ceip.CeipConfigProvider;
import com.vmware.ph.phservice.common.ph.PayloadAuditPersisterProvider;
import com.vmware.ph.phservice.common.ph.PhClientFactory;
import com.vmware.ph.phservice.common.ph.PhDapClient;
import com.vmware.ph.phservice.common.ph.PhEnvironmentProvider;
import com.vmware.ph.phservice.common.ph.PhRtsClient;

public final class DefaultPhClientFactory
implements PhClientFactory {
    private final PhEnvironmentProvider _environmentProvider;
    private final PayloadAuditPersisterProvider _payloadAuditPersisterProvider;
    private final ProxySettingsProvider _proxySettingsProvider;
    private final CeipConfigProvider _ceipConfigProvider;

    public DefaultPhClientFactory(PhEnvironmentProvider environmentProvider, PayloadAuditPersisterProvider payloadAuditPersisterProvider, ProxySettingsProvider proxySettingsProvider, CeipConfigProvider ceipConfigProvider) {
        this._environmentProvider = environmentProvider;
        this._payloadAuditPersisterProvider = payloadAuditPersisterProvider;
        this._proxySettingsProvider = proxySettingsProvider;
        this._ceipConfigProvider = ceipConfigProvider;
    }

    @Override
    public PhClient createPhClient(Collector collector) {
        PhClientBuilder builder = PhClientBuilder.create((PhClientBuilder.Environment)this._environmentProvider.getEnvironment(), (Collector)collector);
        if (this._proxySettingsProvider != null) {
            builder.setProxyProvider(this._proxySettingsProvider);
        }
        if (this._payloadAuditPersisterProvider != null) {
            builder.setPayloadAuditPersister(this._payloadAuditPersisterProvider.getPayloadAuditPersister());
        }
        builder.setCeipConfigProvider(this._ceipConfigProvider);
        PhClient client = builder.build();
        return client;
    }

    @Override
    public PhRtsClient createPhRtsClient() {
        return new PhRtsClient(this._environmentProvider.getEnvironment(), this._proxySettingsProvider, this._ceipConfigProvider);
    }

    @Override
    public PhDapClient createPhDapClient() {
        return new PhDapClient(this._environmentProvider.getEnvironment(), this._proxySettingsProvider, this._ceipConfigProvider);
    }
}

