/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.common.ph;

import com.vmware.ph.client.api.impl.PhClientBuilder;
import com.vmware.ph.phservice.common.ConfigurationService;
import com.vmware.ph.phservice.common.ph.PhEnvironmentProvider;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultPhEnvironmentProvider
implements PhEnvironmentProvider {
    private static final Log logger = LogFactory.getLog(DefaultPhEnvironmentProvider.class);
    private final ConfigurationService _configurationService;
    private final String _targetEnvironmentPropertyName;
    private final String _targetEnvironment;

    public DefaultPhEnvironmentProvider(ConfigurationService configurationService, String targetEnvironmentPropertyName) {
        this(configurationService, targetEnvironmentPropertyName, null);
    }

    public DefaultPhEnvironmentProvider(String targetEnvironment) {
        this(null, null, targetEnvironment);
    }

    DefaultPhEnvironmentProvider(ConfigurationService configurationService, String targetEnvironmentPropertyName, String targetEnvironment) {
        this._configurationService = configurationService;
        this._targetEnvironmentPropertyName = targetEnvironmentPropertyName;
        this._targetEnvironment = targetEnvironment;
    }

    @Override
    public PhClientBuilder.Environment getEnvironment() {
        PhClientBuilder.Environment result = PhClientBuilder.Environment.PRODUCTION;
        String targetEnvironment = this.getTargetEnvironment();
        if (StringUtils.isNotBlank((String)targetEnvironment)) {
            try {
                result = PhClientBuilder.Environment.valueOf((String)targetEnvironment.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)String.format("Cannot convert string value '%s' to Environment enum, will default to %s.", targetEnvironment, result));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("environment to be used: " + result));
        }
        return result;
    }

    private String getTargetEnvironment() {
        String targetEnvironment = this._targetEnvironment;
        if (StringUtils.isEmpty((String)targetEnvironment) && this._configurationService != null) {
            targetEnvironment = this._configurationService.getProperty(this._targetEnvironmentPropertyName);
        }
        return targetEnvironment;
    }
}

