/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.common.ph;

import com.vmware.ph.client.api.impl.PhClientBuilder;
import com.vmware.ph.common.net.ProxySettingsProvider;
import com.vmware.ph.config.ceip.CeipConfigProvider;
import com.vmware.ph.phservice.common.ph.BasePhRestClient;
import com.vmware.ph.phservice.common.ph.PluginData;
import com.vmware.ph.phservice.common.ph.PluginResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.json.JSONArray;
import org.json.JSONObject;

public class PhDapClient
extends BasePhRestClient {
    private static final String STAGE_DATAAPP_PATH = "/ph-stg/api/dataapp/send";
    private static final String PROD_DATAAPP_PATH = "/ph/api/dataapp/send";
    private static final String STAGE_QUERY_PATH = "/ph-stg/api/v1/results";
    private static final String PROD_QUERY_PATH = "/ph/api/v1/results";
    private static final String STRING_BEGINNING = "\\A";
    private static final Log _log = LogFactory.getLog(PhDapClient.class);

    public PhDapClient(PhClientBuilder.Environment environment, ProxySettingsProvider proxySettingsProvider, CeipConfigProvider ceipConfigProvider) {
        super(environment, proxySettingsProvider, ceipConfigProvider);
    }

    PhDapClient(PhClientBuilder.Environment environment, CloseableHttpClient httpClient, CeipConfigProvider ceipConfigProvider) {
        super(environment, httpClient, ceipConfigProvider);
    }

    public void sendPluginData(String collectorId, String collectorInstanceId, String version, String deploymentSecret, PluginData pluginData, Map<String, String> additionalUrlParams) {
        block5: {
            if (!this.isCeipEnabled()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("CEIP is not enabled - not sending collected data to DAP plugin [" + collectorId + ", " + collectorInstanceId + "] "));
                }
                return;
            }
            try {
                String urlPath = this.isProd() ? PROD_DATAAPP_PATH : STAGE_DATAAPP_PATH;
                URI uri = PhDapClient.createPhSendUri(urlPath, collectorId, collectorInstanceId, version, additionalUrlParams);
                HttpPost httpPost = new HttpPost(uri);
                String jsonLdData = PhDapClient.getJsonLdData(collectorInstanceId, deploymentSecret, pluginData);
                byte[] postData = PhDapClient.gzip(jsonLdData);
                httpPost.setEntity((HttpEntity)new ByteArrayEntity(postData));
                httpPost.addHeader("Content-Type", "application/gzip");
                Map<String, String> pluginDataHeaders = PhDapClient.getPluginDataHeaders(deploymentSecret, pluginData);
                for (Map.Entry<String, String> entry : pluginDataHeaders.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
                this._httpClient.execute((HttpUriRequest)httpPost);
            }
            catch (IOException | URISyntaxException e) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)("Exception occurred while sending collected data to DAP plugin [" + collectorId + ", " + collectorInstanceId + "]."), (Throwable)e);
            }
        }
    }

    public PluginResult queryPluginResult(String collectorId, String collectorInstanceId, String deploymentSecret, String dataType, String objectId) {
        if (!this.isCeipEnabled()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("CEIP is not enabled - not invoking data app result service for DAP plugin [" + collectorId + ", " + collectorInstanceId + "] " + "for object '" + objectId + "'."));
            }
            return null;
        }
        try {
            String urlPath = this.isProd() ? PROD_QUERY_PATH : STAGE_QUERY_PATH;
            URI uri = PhDapClient.createObjectQueryUri(urlPath, collectorId, collectorInstanceId, dataType, objectId);
            HttpGet httpGet = new HttpGet(uri);
            httpGet.addHeader("X-Deployment-Secret", deploymentSecret);
            httpGet.addHeader("Content-Type", "application/json");
            String responseBody = null;
            try (CloseableHttpResponse response = this._httpClient.execute((HttpUriRequest)httpGet);){
                InputStream responseStream = response.getEntity().getContent();
                responseBody = PhDapClient.readStream(responseStream);
            }
            JSONObject responseJson = new JSONObject(responseBody);
            JSONArray jsonArray = responseJson.getJSONArray("results");
            JSONObject responseData = jsonArray.getJSONObject(0);
            Object content = responseData.get("content");
            Long timestamp = responseData.getLong("processedDate");
            PluginResult result = new PluginResult(objectId, content, new Date(timestamp));
            return result;
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Exception occurred while querying result DAP plugin [" + collectorId + ", " + collectorInstanceId + "] " + "for object '" + objectId + "'."), (Throwable)e);
            }
            return null;
        }
    }

    private static String getJsonLdData(String collectorInstanceId, String deploymentSecret, PluginData pluginData) {
        JSONObject pluginDataJson = PhDapClient.buildPluginDataJson(pluginData);
        JSONObject secretDataJson = PhDapClient.buildSecretObjectJson(collectorInstanceId, deploymentSecret);
        JSONArray requestJsonArray = new JSONArray();
        requestJsonArray.put((Object)pluginDataJson);
        requestJsonArray.put((Object)secretDataJson);
        return requestJsonArray.toString();
    }

    private static String readStream(InputStream inputStream) {
        Scanner streamScanner = new Scanner(inputStream, StandardCharsets.UTF_8.name()).useDelimiter(STRING_BEGINNING);
        return streamScanner.hasNext() ? streamScanner.next() : "";
    }

    private static JSONObject buildPluginDataJson(PluginData pluginData) {
        JSONObject pluginDataJson = new JSONObject();
        pluginDataJson.put("@plugin_type", (Object)pluginData.getPluginType());
        pluginDataJson.put("@type", (Object)pluginData.getDataType());
        if (pluginData.getObjectId() != null) {
            pluginDataJson.put("@id", (Object)pluginData.getObjectId());
        }
        pluginDataJson.put("data", pluginData.getData());
        return pluginDataJson;
    }

    private static JSONObject buildSecretObjectJson(String collectorInstanceId, String deploymentSecret) {
        JSONObject deploymentJson = new JSONObject();
        deploymentJson.put("@type", (Object)"pa__deployment_secret");
        deploymentJson.put("@id", (Object)collectorInstanceId);
        deploymentJson.put("secret", (Object)deploymentSecret);
        return deploymentJson;
    }

    private static Map<String, String> getPluginDataHeaders(String deploymentSecret, PluginData pluginData) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put("X-Deployment-Secret", deploymentSecret);
        headers.put("X-Plugin-Type", pluginData.getPluginType());
        headers.put("X-Data-Type", pluginData.getDataType());
        if (pluginData.getObjectId() != null) {
            headers.put("X-Object-Id", pluginData.getObjectId());
        }
        return headers;
    }

    private static byte[] gzip(String strData) throws UnsupportedEncodingException, IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        GZIPOutputStream gzipOut = new GZIPOutputStream(byteOut);
        gzipOut.write(strData.getBytes("UTF-8"));
        gzipOut.finish();
        byte[] gzipData = byteOut.toByteArray();
        return gzipData;
    }
}

