/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.common.ph;

import com.vmware.ph.client.api.commondataformat.PayloadEnvelope;
import com.vmware.ph.client.api.commondataformat.types.CdfAble;
import com.vmware.ph.client.api.commondataformat20.Payload20;
import com.vmware.ph.client.api.commondataformat20.types.JsonLd;
import com.vmware.ph.phservice.common.cdf.PayloadUploader;
import com.vmware.ph.phservice.common.ph.PhClientFactory;
import com.vmware.ph.phservice.common.ph.PhDapClient;
import com.vmware.ph.phservice.common.ph.PluginData;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONObject;

public class PhDataAppPayloadUploader
implements PayloadUploader {
    private final String _pluginType;
    private final String _deploymentSecret;
    private final ExecutorService _executorService;
    private final PhClientFactory _phClientFactory;

    public PhDataAppPayloadUploader(String pluginType, String deploymentSecret, ExecutorService executorService, PhClientFactory phClientFactory) {
        this._pluginType = pluginType;
        this._deploymentSecret = deploymentSecret;
        this._executorService = executorService;
        this._phClientFactory = phClientFactory;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public Future<?> uploadPayload(final Payload20 payload20, final PayloadEnvelope payloadEnvelope, final String uploadId) {
        Future<Void> result = this._executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws PayloadUploader.PayloadUploadException {
                PhDataAppPayloadUploader.this.uploadPayloadBlocking(payload20, payloadEnvelope, uploadId);
                return null;
            }
        });
        return result;
    }

    @Override
    public Future<?> uploadFile(String collectorId, String instanceId, String uploadId, File fileToUpload) {
        throw new UnsupportedOperationException("Uploading a file to the DataApp API is currently unsupported.");
    }

    private void uploadPayloadBlocking(Payload20 payload20, PayloadEnvelope payloadEnvelope, String uploadId) throws PayloadUploader.PayloadUploadException {
        Collection<JSONObject> jsonLds = this.filterJsonObjects(payload20);
        JSONArray jsonArray = new JSONArray(jsonLds);
        try (PhDapClient phDapClient = this._phClientFactory.createPhDapClient();){
            PluginData pluginData = new PluginData(this._pluginType, jsonArray, null, null);
            phDapClient.sendPluginData(payloadEnvelope.getCollector().getCollectorId(), payloadEnvelope.getCollector().getCollectorInstanceId(), null, this._deploymentSecret, pluginData, null);
        }
        catch (Exception e) {
            throw new PayloadUploader.PayloadUploadException(e);
        }
    }

    private Collection<JSONObject> filterJsonObjects(Payload20 payload20) {
        ArrayList<JSONObject> jsonLds = new ArrayList<JSONObject>();
        Collection<CdfAble> cdfs = payload20.getCdfs();
        for (CdfAble cdf : cdfs) {
            if (!(cdf instanceof JsonLd)) continue;
            jsonLds.add(((JsonLd)cdf).getJson());
        }
        return jsonLds;
    }
}

