/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.common.ph;

import com.vmware.ph.client.api.impl.PhClientBuilder;
import com.vmware.ph.common.net.ProxySettingsProvider;
import com.vmware.ph.config.ceip.CeipConfigProvider;
import com.vmware.ph.phservice.common.ph.BasePhRestClient;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class PhRtsClient
extends BasePhRestClient {
    private static final String STAGE_PATH = "/ph-stg/api/hyper/send";
    private static final String PROD_PATH = "/ph/api/hyper/send";
    private static final Log _log = LogFactory.getLog(PhRtsClient.class);

    public PhRtsClient(PhClientBuilder.Environment environment, CeipConfigProvider ceipConfigProvider) {
        this(environment, (ProxySettingsProvider)null, ceipConfigProvider);
    }

    public PhRtsClient(PhClientBuilder.Environment environment, ProxySettingsProvider proxySettingsProvider, CeipConfigProvider ceipConfigProvider) {
        super(environment, proxySettingsProvider, ceipConfigProvider);
    }

    PhRtsClient(PhClientBuilder.Environment environment, CloseableHttpClient httpClient, CeipConfigProvider ceipConfigProvider) {
        super(environment, httpClient, ceipConfigProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(String collectorId, String collectorInstanceId, String version, byte[] data, boolean isCompressed) {
        if (!this.isCeipEnabled()) {
            return 202;
        }
        int responseStatusCode = 500;
        try {
            String urlPath = this.isProd() ? PROD_PATH : STAGE_PATH;
            URI uri = PhRtsClient.createPhSendUri(urlPath, collectorId, collectorInstanceId, version, null);
            HttpPost httpPost = PhRtsClient.createHttpPostRequest(uri, data, isCompressed);
            try (CloseableHttpResponse httpResponse = this._httpClient.execute((HttpUriRequest)httpPost);){
                responseStatusCode = httpResponse.getStatusLine().getStatusCode();
            }
        }
        catch (IOException | URISyntaxException e) {
            _log.error((Object)"Failed to execute request.", (Throwable)e);
            responseStatusCode = 400;
        }
        return responseStatusCode;
    }

    private static HttpPost createHttpPostRequest(URI uri, byte[] data, boolean isCompressed) {
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeader("Content-Type", "application/json; charset=utf-8");
        if (isCompressed) {
            httpPost.setHeader("Content-Encoding", "gzip");
        }
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(data));
        return httpPost;
    }
}

