/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.common;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.provider.DataProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class QuerySchemaUtil {
    public static QuerySchema resolveConflict(QuerySchema querySchema, DataProvider ... conflictingDataProviders) {
        QuerySchema nonConflictQuerySchema = querySchema;
        for (DataProvider dataProvider : conflictingDataProviders) {
            nonConflictQuerySchema = QuerySchemaUtil.getDifference(nonConflictQuerySchema, dataProvider.getSchema());
        }
        return nonConflictQuerySchema;
    }

    public static QuerySchema getDifference(QuerySchema schema1, QuerySchema schema2) {
        Map schema1Models = schema1.getModels();
        Map schema2Models = schema2.getModels();
        HashMap difference = new HashMap(schema1Models);
        for (String modelKey : schema2Models.keySet()) {
            difference.remove(modelKey);
        }
        return QuerySchema.forModels(difference);
    }

    public static List<String> getSupportedQueryPropertyNames(String queryResourceModelType, List<String> queryPropertyNames, QuerySchema supportedQuerySchema) {
        QuerySchema.ModelInfo supportedQueryModelInfo = (QuerySchema.ModelInfo)supportedQuerySchema.getModels().get(queryResourceModelType);
        if (supportedQueryModelInfo == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> supportedQueryPropertyNames = new ArrayList<String>();
        for (String queryPropertyName : queryPropertyNames) {
            String nonQualifiedQueryPropertyName = QuerySchemaUtil.getActualPropertyName(queryPropertyName);
            if (!supportedQueryModelInfo.getProperties().containsKey(nonQualifiedQueryPropertyName)) continue;
            supportedQueryPropertyNames.add(queryPropertyName);
        }
        return supportedQueryPropertyNames;
    }

    public static List<String> getNonQualifiedPropertyNames(List<String> queryProperties) {
        ArrayList<String> nonQualifiedPropertyNames = new ArrayList<String>();
        for (String queryPropertyName : queryProperties) {
            String nonQualifiedQueryPropertyName = QuerySchemaUtil.getActualPropertyName(queryPropertyName);
            nonQualifiedPropertyNames.add(nonQualifiedQueryPropertyName);
        }
        return nonQualifiedPropertyNames;
    }

    public static String getActualPropertyName(String queryProperty) {
        if (queryProperty.startsWith("@")) {
            return queryProperty;
        }
        int index = queryProperty.indexOf("/");
        if (index != -1) {
            return queryProperty.substring(index + 1);
        }
        return queryProperty;
    }

    public static boolean isQueryPropertyModelKey(String queryProperty) {
        Validate.notEmpty((String)queryProperty);
        return queryProperty.endsWith("@modelKey");
    }

    public static boolean isQueryPropertySpecialProperty(String property) {
        Validate.notEmpty((String)property);
        return property.equals("@type") || property.equals("@modelKey");
    }
}

