/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.common;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.ph.phservice.provider.common.QuerySchemaUtil;
import java.util.ArrayList;
import java.util.List;

public final class QueryUtil {
    private QueryUtil() {
    }

    public static boolean selectsActualProperty(Query query, String actualProperty) {
        if (query == null || actualProperty == null) {
            return false;
        }
        List queryProperties = query.getProperties();
        boolean containsProperty = false;
        for (String queryProperty : queryProperties) {
            if (!actualProperty.equals(QuerySchemaUtil.getActualPropertyName(queryProperty))) continue;
            containsProperty = true;
        }
        return containsProperty;
    }

    public static <T> List<T> getFilterPropertyComparableValues(Query query, String filterProperty) {
        ArrayList<Object> comparableValues = new ArrayList<Object>();
        if (query != null && query.getFilter() != null && filterProperty != null) {
            List predicates = query.getFilter().getCriteria();
            for (PropertyPredicate predicate : predicates) {
                if (!QuerySchemaUtil.getActualPropertyName(predicate.getProperty()).equals(filterProperty)) continue;
                Object comparableValue = predicate.getComparableValue();
                if (comparableValue instanceof List) {
                    for (Object value : (List)comparableValue) {
                        comparableValues.add(value);
                    }
                    continue;
                }
                comparableValues.add(comparableValue);
            }
        }
        return comparableValues;
    }
}

