/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.common;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.provider.DataProvider;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SafeDataProviderWrapper
implements DataProvider {
    private static final Log _log = LogFactory.getLog(SafeDataProviderWrapper.class);
    private final DataProvider _wrappedDataProvider;

    public SafeDataProviderWrapper(DataProvider wrappedDataProvider) {
        this._wrappedDataProvider = wrappedDataProvider;
    }

    public ResultSet executeQuery(Query query) {
        try {
            return this._wrappedDataProvider.executeQuery(query);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Throwable e) {
            _log.error((Object)"Error while executing data provider query.Will return empty response.", e);
            ResultSet.Builder resultSetBuilder = ResultSet.Builder.properties((List)query.getProperties());
            return resultSetBuilder.build();
        }
    }

    public QuerySchema getSchema() {
        try {
            return this._wrappedDataProvider.getSchema();
        }
        catch (Throwable e) {
            _log.error((Object)"Error while retrieving data provider schema.", e);
            return QuerySchema.EMPTY_SCHEMA;
        }
    }
}

