/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.contentlibrary;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.provider.DataProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContentLibraryDataProviderDecorator
implements DataProvider {
    private static final String MODEL_WORD = "Model";
    private final DataProvider _clsDataProvider;
    private QuerySchema _decoratedQuerySchema;
    private QuerySchema _clsQuerySchema;

    public ContentLibraryDataProviderDecorator(DataProvider clsDataProvider) {
        this._clsDataProvider = clsDataProvider;
    }

    public QuerySchema getSchema() {
        if (this._decoratedQuerySchema == null) {
            this._clsQuerySchema = this._clsDataProvider.getSchema();
            this._decoratedQuerySchema = ContentLibraryDataProviderDecorator.buildDecoratedQuerySchemaFromClsQuerySchema(this._clsQuerySchema);
        }
        return this._decoratedQuerySchema;
    }

    public ResultSet executeQuery(Query decoratedQuery) {
        Query clsQuery = ContentLibraryDataProviderDecorator.buildClsQueryFromDecoratedQuery(decoratedQuery, this._clsQuerySchema);
        ResultSet clsResultSet = this._clsDataProvider.executeQuery(clsQuery);
        ResultSet decoratedResultSet = ContentLibraryDataProviderDecorator.buildDecoratedResultSetFromClsResultSet(clsResultSet, decoratedQuery);
        return decoratedResultSet;
    }

    private static QuerySchema buildDecoratedQuerySchemaFromClsQuerySchema(QuerySchema clsSchema) {
        Map clsResourceModels = clsSchema.getModels();
        HashMap<String, QuerySchema.ModelInfo> modifiedResourceModels = new HashMap<String, QuerySchema.ModelInfo>();
        for (Map.Entry clsResourceModel : clsResourceModels.entrySet()) {
            String clsResourceModelName = (String)clsResourceModel.getKey();
            QuerySchema.ModelInfo clsResourceModelInfo = (QuerySchema.ModelInfo)clsResourceModel.getValue();
            modifiedResourceModels.put(ContentLibraryDataProviderDecorator.stripModelWordFromResourceName(clsResourceModelName), clsResourceModelInfo);
        }
        return QuerySchema.forModels(modifiedResourceModels);
    }

    private static Query buildClsQueryFromDecoratedQuery(Query decoratedQuery, QuerySchema clsQuerySchema) {
        String decoratedQueryModelName = (String)decoratedQuery.getResourceModels().iterator().next();
        Map clsResourceModels = clsQuerySchema.getModels();
        if (clsResourceModels.get(decoratedQueryModelName) != null) {
            return decoratedQuery;
        }
        String clsQueryModelName = decoratedQueryModelName + MODEL_WORD;
        List<String> clsQueryProperties = ContentLibraryDataProviderDecorator.changeQueryPropertiesModelName(clsQueryModelName, decoratedQuery.getProperties());
        Query clsQuery = Query.Builder.select(clsQueryProperties).from(new String[]{clsQueryModelName}).offset(decoratedQuery.getOffset()).limit(decoratedQuery.getLimit()).orderBy(decoratedQuery.getSortCriteria()).build();
        return clsQuery;
    }

    private static ResultSet buildDecoratedResultSetFromClsResultSet(ResultSet clsResultSet, Query decoratedQuery) {
        ResultSet.Builder resultSetBuilder = ResultSet.Builder.properties((List)decoratedQuery.getProperties());
        for (ResourceItem clsResourceItem : clsResultSet.getItems()) {
            resultSetBuilder.item(clsResourceItem.getKey(), clsResourceItem.getPropertyValues());
        }
        return resultSetBuilder.build();
    }

    private static String stripModelWordFromResourceName(String resourceName) {
        int modelWordStartIndex = resourceName.indexOf(MODEL_WORD);
        if (modelWordStartIndex > 0) {
            resourceName = resourceName.substring(0, modelWordStartIndex);
        }
        return resourceName;
    }

    private static List<String> changeQueryPropertiesModelName(String newModelName, List<String> qualifiedQueryProperties) {
        ArrayList<String> modifiedQueryProperties = new ArrayList<String>();
        for (String qualifiedQueryProperty : qualifiedQueryProperties) {
            if (qualifiedQueryProperty.startsWith("@")) {
                modifiedQueryProperties.add(qualifiedQueryProperty);
                continue;
            }
            int nonQualifiedPartStartIndex = qualifiedQueryProperty.indexOf(47);
            String changedQualifierQueryProperty = newModelName + qualifiedQueryProperty.substring(nonQualifiedPartStartIndex);
            modifiedQueryProperties.add(changedQualifierQueryProperty);
        }
        return modifiedQueryProperties;
    }
}

