/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.contentlibrary;

import com.vmware.cis.data.internal.adapters.lookup.ServiceEndpointInfo;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiAuthenticator;
import com.vmware.cis.data.internal.adapters.vapi.VapiDataProviderConfig;
import com.vmware.cis.data.internal.adapters.vapi.VapiPropertyValueConverter;
import com.vmware.cis.data.internal.adapters.vapi.impl.VapiDataProvider;
import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.cis.data.internal.provider.DataProviderConnection;
import com.vmware.cis.data.internal.provider.DataProviderConnector;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.cls.util.StructTypeUtil;
import com.vmware.ph.phservice.ciscommon.lookup.LookupClient;
import com.vmware.ph.phservice.ciscommon.lookup.ServiceLocatorUtil;
import com.vmware.ph.phservice.provider.contentlibrary.ContentLibraryDataProviderDecorator;
import com.vmware.ph.phservice.provider.contentlibrary.SsoTokenProviderAuthenticationTokenSource;
import com.vmware.ph.phservice.provider.contentlibrary.VapiPropertyValueConverterImpl;
import com.vmware.ph.phservice.provider.vimcommon.VimContext;
import com.vmware.ph.phservice.provider.vimcommon.VimDataProvidersConnection;
import com.vmware.ph.phservice.vapicommon.MapBasedVapiTypeProvider;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import java.security.KeyStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentLibraryDataProvidersConnection
extends VimDataProvidersConnection {
    private static final String PRODUCT_CIS = "com.vmware.cis";
    private static final String SERVICE_TYPE_CLS = "cis.cls";
    private static final String ENDPOINT_CLS = "com.vmware.cis.cls.vapi.https";
    private static final String PROTOCOL_VAPI = "vapi.json.https";
    private static final Log _log = LogFactory.getLog(ContentLibraryDataProvidersConnection.class);
    private DataProviderConnection _clsDataProvierConnection;

    public ContentLibraryDataProvidersConnection(VimContext vimContext) {
        super(vimContext);
    }

    @Override
    public synchronized List<DataProvider> getDataProviders() throws Exception {
        if (this._vimContext.getVimTrustedStore() == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)String.format("%s is not provided with trusted roots key store. Without this keystore the collection process is not possible. Returning empty DataProvider list.", this.getClass().getSimpleName()));
            }
            return Collections.emptyList();
        }
        if (this._clsDataProvierConnection == null) {
            this.acquireContentLibraryDataProviderConnection();
        }
        List<DataProvider> dataProviders = Collections.emptyList();
        if (this._clsDataProvierConnection != null) {
            dataProviders = Collections.singletonList(new ContentLibraryDataProviderDecorator(this._clsDataProvierConnection.getDataProvider()));
        }
        return dataProviders;
    }

    @Override
    public synchronized void close() {
        super.close();
        if (this._clsDataProvierConnection != null) {
            block3: {
                try {
                    this._clsDataProvierConnection.close();
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Object)"Could not close the data provider connection to the Content Library.");
                }
            }
            this._clsDataProvierConnection = null;
        }
    }

    private void acquireContentLibraryDataProviderConnection() {
        ServiceEndpointInfo clsServiceEndpointInfo = ContentLibraryDataProvidersConnection.discoverContentLibraryServiceEndpointInfo(this._vimContext);
        if (clsServiceEndpointInfo == null) {
            return;
        }
        DataProviderConnector clsDataProviderConnector = ContentLibraryDataProvidersConnection.createVapiDataProviderConnector(clsServiceEndpointInfo);
        SsoTokenProviderAuthenticationTokenSource authTokenSource = new SsoTokenProviderAuthenticationTokenSource(this._vimContext.getSsoTokenProvider());
        this._clsDataProvierConnection = clsDataProviderConnector.getConnection((AuthenticationTokenSource)authTokenSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceEndpointInfo discoverContentLibraryServiceEndpointInfo(VimContext vimContext) {
        ServiceRegistration.Info[] clsServiceInfos = null;
        try (LookupClient lookupClient = vimContext.getLookupClientBuilder(true).build();){
            String nodeId = ServiceLocatorUtil.getNodeIdByServiceId(lookupClient, vimContext.getVcInstanceUuid());
            clsServiceInfos = ServiceLocatorUtil.findServiceByServiceAndEndpointType(lookupClient, new ServiceRegistration.ServiceType(PRODUCT_CIS, SERVICE_TYPE_CLS), new ServiceRegistration.EndpointType(PROTOCOL_VAPI, ENDPOINT_CLS), nodeId);
        }
        ServiceEndpointInfo clsServiceEndpointInfo = null;
        if (clsServiceInfos != null) {
            clsServiceEndpointInfo = ContentLibraryDataProvidersConnection.createContentLibraryServiceEndpointInfo((ServiceRegistration.Info)clsServiceInfos[0], vimContext.getVimTrustedStore());
        }
        return clsServiceEndpointInfo;
    }

    private static VapiDataProviderConfig createContentLibraryVapiDataProviderConfig() {
        HashMap<String, StructType> clsCanonicalNameToStructMap = new HashMap<String, StructType>();
        StructTypeUtil.populateCanonicalNameToStructTypeMap(clsCanonicalNameToStructMap);
        MapBasedVapiTypeProvider clsVapiTypeProvider = new MapBasedVapiTypeProvider(clsCanonicalNameToStructMap);
        VapiDataProviderConfig clsVapiDataProviderConfig = VapiDataProviderConfig.Builder.create().withPropertyValueConverter((VapiPropertyValueConverter)new VapiPropertyValueConverterImpl(clsVapiTypeProvider)).build();
        return clsVapiDataProviderConfig;
    }

    private static DataProviderConnector createVapiDataProviderConnector(ServiceEndpointInfo endpoint) {
        VapiDataProviderConfig vapiDataProviderConfig = ContentLibraryDataProvidersConnection.createContentLibraryVapiDataProviderConfig();
        VapiAuthenticator authenticator = vapiDataProviderConfig.getAuthenticatorFactory().getAuthenticator(endpoint);
        VapiDataProvider vapiProvider = new VapiDataProvider(endpoint.getUrl(), endpoint.getTrustStore(), vapiDataProviderConfig, authenticator);
        return vapiProvider;
    }

    private static ServiceEndpointInfo createContentLibraryServiceEndpointInfo(ServiceRegistration.Info clsServiceInfo, KeyStore trustStore) {
        ServiceRegistration.Endpoint[] clsServiceEndpoints = clsServiceInfo.getServiceEndpoints();
        if (clsServiceEndpoints == null) {
            return null;
        }
        ServiceRegistration.Endpoint clsEndpoint = clsServiceEndpoints[0];
        String serviceTypeId = clsServiceInfo.serviceType.product + ":" + clsServiceInfo.serviceType.type;
        ServiceEndpointInfo clsServiceEndpointInfo = new ServiceEndpointInfo(serviceTypeId, clsEndpoint.getUrl(), clsServiceInfo.nodeId, trustStore, clsEndpoint.endpointType.type, clsEndpoint.endpointType.protocol, clsServiceInfo.serviceId, null);
        return clsServiceEndpointInfo;
    }
}

