/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.contentlibrary;

import com.vmware.cis.data.internal.adapters.vapi.VapiPropertyValueConverter;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import com.vmware.ph.phservice.provider.common.QuerySchemaUtil;
import com.vmware.ph.phservice.provider.contentlibrary.VapiPropertyTypeResolver;
import com.vmware.ph.phservice.vapicommon.VapiTypeProvider;
import com.vmware.ph.phservice.vapicommon.util.VapiUriSchemeUtil;
import com.vmware.vapi.bindings.ApiEnumeration;
import com.vmware.vapi.bindings.type.OptionalType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.data.BlobValue;
import com.vmware.vapi.data.BooleanValue;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DoubleValue;
import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.SecretValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.TypeConverterImpl;
import com.vmware.vapi.internal.bindings.convert.ConverterFactory;
import com.vmware.vapi.internal.bindings.convert.NameToTypeResolver;
import com.vmware.vapi.internal.bindings.convert.impl.DefaultConverterFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VapiPropertyValueConverterImpl
implements VapiPropertyValueConverter {
    private final VapiTypeProvider _vapiTypeProvider;
    private TypeConverter _vapiTypeConverter;

    public VapiPropertyValueConverterImpl(VapiTypeProvider vapiTypeProvider) {
        this._vapiTypeProvider = vapiTypeProvider;
        this.initTypeConverter();
    }

    public Object fromVapiResultDataValue(String property, DataValue resourceTypeValue, DataValue dataValue) {
        VapiPropertyValueConverterImpl.validateResourceType(resourceTypeValue, property);
        if (dataValue == null) {
            return null;
        }
        Object vapiRsult = null;
        if (property.equals("@modelKey")) {
            VapiPropertyValueConverterImpl.validateStringValue(dataValue, property);
            vapiRsult = VapiUriSchemeUtil.createUri(((StringValue)resourceTypeValue).getValue(), ((StringValue)dataValue).getValue());
        } else {
            Type propertyType = this.fixOptionals(this.getVapiTypeOfProperty(property), dataValue);
            if (propertyType == null && dataValue instanceof StructValue) {
                StructValue structValue = (StructValue)dataValue;
                propertyType = this._vapiTypeProvider.getResourceModelType(structValue.getName());
            }
            vapiRsult = propertyType != null ? this.toBinding(dataValue, propertyType, property) : this.fromUntypedDataValue(dataValue);
        }
        return vapiRsult;
    }

    public DataValue toVapiComparableValue(String property, Object comparableValue) {
        if (comparableValue instanceof Integer) {
            Integer integerValue = (Integer)comparableValue;
            return new IntegerValue(integerValue.longValue());
        }
        if (comparableValue instanceof Long) {
            return new IntegerValue(((Long)comparableValue).longValue());
        }
        if (comparableValue instanceof Boolean) {
            return BooleanValue.getInstance((boolean)((Boolean)comparableValue));
        }
        if (comparableValue instanceof String) {
            return new StringValue((String)comparableValue);
        }
        if (comparableValue instanceof Float) {
            Float floatValue = (Float)comparableValue;
            return new DoubleValue(floatValue.doubleValue());
        }
        if (comparableValue instanceof Double) {
            return new DoubleValue(((Double)comparableValue).doubleValue());
        }
        if (comparableValue instanceof ApiEnumeration) {
            return new StringValue(((ApiEnumeration)comparableValue).name());
        }
        if (comparableValue instanceof URI && VapiUriSchemeUtil.isVapiUri((URI)comparableValue)) {
            URI uri = (URI)comparableValue;
            String key = VapiUriSchemeUtil.getId(uri);
            return new StringValue(key);
        }
        throw new IllegalArgumentException(String.format("Unsupported comparable value of type %s: %s", comparableValue.getClass().getCanonicalName(), comparableValue));
    }

    public List<DataValue> toVapiComparableList(String property, Collection<?> comparableCollection) {
        ArrayList<DataValue> vapiComparableList = new ArrayList<DataValue>(comparableCollection.size());
        for (Object comparableElement : comparableCollection) {
            vapiComparableList.add(this.toVapiComparableValue(property, comparableElement));
        }
        return vapiComparableList;
    }

    public boolean isTypeRequired() {
        return true;
    }

    private void initTypeConverter() {
        this._vapiTypeConverter = new TypeConverterImpl((ConverterFactory)new DefaultConverterFactory(new NameToTypeResolver(){

            public Type resolve(String name) {
                StructType type = VapiPropertyValueConverterImpl.this._vapiTypeProvider.getResourceModelType(name);
                return type;
            }
        }));
    }

    private static void validateResourceType(DataValue resourceTypeValue, String property) {
        if (resourceTypeValue == null) {
            throw new IllegalArgumentException("The resourceType of " + property + " property must not be null!");
        }
        if (!(resourceTypeValue instanceof StringValue)) {
            throw new IllegalArgumentException(String.format("Resource type of property '%s' must be a StringValue and not %s: %s", property, resourceTypeValue.getClass().getCanonicalName(), resourceTypeValue));
        }
    }

    private static void validateStringValue(DataValue value, String property) {
        if (!(value instanceof StringValue)) {
            throw new IllegalArgumentException(String.format("Property '%s' must be a StringValue and not %s: %s", property, value.getClass().getCanonicalName(), value));
        }
    }

    private Object toBinding(DataValue dataValue, Type bindingType, String property) {
        try {
            return this._vapiTypeConverter.convertToJava(dataValue, bindingType);
        }
        catch (RuntimeException ex) {
            throw new IllegalStateException("Could not convert value of property " + property, ex);
        }
    }

    private Object fromUntypedDataValue(DataValue dataValue) {
        if (dataValue instanceof StringValue) {
            return ((StringValue)dataValue).getValue();
        }
        if (dataValue instanceof IntegerValue) {
            return ((IntegerValue)dataValue).getValue();
        }
        if (dataValue instanceof BooleanValue) {
            return ((BooleanValue)dataValue).getValue();
        }
        if (dataValue instanceof SecretValue) {
            return ((SecretValue)dataValue).getValue();
        }
        if (dataValue instanceof DoubleValue) {
            return ((DoubleValue)dataValue).getValue();
        }
        if (dataValue instanceof BlobValue) {
            return ((BlobValue)dataValue).getValue();
        }
        return dataValue;
    }

    private Type fixOptionals(Type bindingType, DataValue dataValue) {
        if (bindingType == null) {
            return null;
        }
        if (bindingType instanceof OptionalType && !(dataValue instanceof OptionalValue)) {
            return ((OptionalType)bindingType).getElementType();
        }
        return bindingType;
    }

    private Type getVapiTypeOfProperty(String property) {
        assert (property != null);
        if (QuerySchemaUtil.isQueryPropertySpecialProperty(property)) {
            return null;
        }
        QualifiedProperty qualifiedProperty = QualifiedProperty.forQualifiedName((String)property);
        String modelCanonicalName = VapiPropertyValueConverterImpl.toCanonicalName(qualifiedProperty.getResourceModel());
        StructType modelType = this._vapiTypeProvider.getResourceModelType(modelCanonicalName);
        if (modelType == null) {
            return null;
        }
        Type propertyType = VapiPropertyTypeResolver.resolvePropertyType(modelType, qualifiedProperty.getSimpleProperty());
        return propertyType;
    }

    private static String toCanonicalName(String mixedCaseName) {
        StringBuilder canonical = new StringBuilder();
        char prev = '\u0000';
        for (int i = 0; i < mixedCaseName.length(); ++i) {
            char ch = mixedCaseName.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (Character.isLowerCase(prev)) {
                    canonical.append('_');
                }
                canonical.append(Character.toLowerCase(ch));
            } else {
                canonical.append(ch);
            }
            prev = ch;
        }
        return canonical.toString();
    }
}

