/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.esx.files;

import com.vmware.ph.phservice.provider.esx.files.util.EsxFileLayout;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.ph.phservice.provider.vimcommon.vc.util.HostReader;
import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;

public class EsxCfgInfoReader {
    private static final String ESX_CFG_INFO_LOCATION = "/cgi-bin/esxcfg-info.cgi?format=xml&subtree=all";
    private static final String VMWARE_CGI_TICKET_HEADER = "vmware_cgi_ticket=";
    private static final Log _log = LogFactory.getLog(EsxCfgInfoReader.class);
    private final VcClient _vcClient;
    private final HttpClient _httpClient;
    private final HostReader _hostReader;

    public EsxCfgInfoReader(VcClient vcClient, HttpClient httpClient) {
        this._vcClient = vcClient;
        this._httpClient = httpClient;
        this._hostReader = new HostReader(this._vcClient);
    }

    EsxCfgInfoReader(VcClient vcClient, HttpClient httpClient, HostReader hostReader) {
        this._vcClient = vcClient;
        this._httpClient = httpClient;
        this._hostReader = hostReader;
    }

    public File getEsxCfgInfo(ManagedObjectReference hostMoRef, List<String> esxCfgInfoFilters, EsxFileLayout fileLayout) {
        Objects.requireNonNull(hostMoRef);
        Objects.requireNonNull(fileLayout);
        if (esxCfgInfoFilters == null || esxCfgInfoFilters.isEmpty()) {
            return null;
        }
        boolean hostCfgInfoDownloadCompleted = false;
        File esxCfgInfoFile = fileLayout.getHostCfgInfoFile(hostMoRef);
        List<String> hostManagementIps = this._hostReader.getManagementIps(hostMoRef);
        for (String hostManagementIp : hostManagementIps) {
            if (hostCfgInfoDownloadCompleted) continue;
            try {
                String hostConfigUrl = this.buildEsxCfgInfoUrl(hostManagementIp, esxCfgInfoFilters);
                this.downloadFileFromEsx(hostConfigUrl, esxCfgInfoFile);
                hostCfgInfoDownloadCompleted = true;
                break;
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)String.format("Could not get collect configuration data from IP '%s'", hostManagementIp), (Throwable)e);
            }
        }
        if (hostCfgInfoDownloadCompleted) {
            return esxCfgInfoFile;
        }
        return null;
    }

    private String buildEsxCfgInfoUrl(String hostManagementIp, List<String> esxCfgInfoFilters) {
        StringBuilder urlSuffix = new StringBuilder(ESX_CFG_INFO_LOCATION);
        for (String esxCfgInfoFilter : esxCfgInfoFilters) {
            urlSuffix.append("&filter=" + esxCfgInfoFilter);
        }
        try {
            URL esxCfgInfoUrl = new URL("https", hostManagementIp, urlSuffix.toString());
            return esxCfgInfoUrl.toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFileFromEsx(String hostFileUrl, File destinationFile) throws IOException {
        SessionManager.GenericServiceTicket serviceTicket = this.obtainGenericServiceTicket(hostFileUrl);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Requesting to download data. Request address is " + hostFileUrl));
        }
        HttpResponse response = this.get(hostFileUrl, serviceTicket);
        FileOutputStream downloadStream = null;
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Request to download data received response: " + response.getStatusLine()));
            }
            downloadStream = new FileOutputStream(destinationFile);
            long contentLength = response.getEntity().getContentLength();
            String destPathName = destinationFile.getAbsolutePath();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("Writing data to file %s, expected data file size (as reported by the HTTP response body length) is (negative means \"don't know\") %d.", destPathName, contentLength));
            }
            long totalRead = IOUtils.copyLarge((InputStream)response.getEntity().getContent(), (OutputStream)downloadStream);
            downloadStream.flush();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("Writing data to file completed. Read %s bytes from HTTP stream, expected %d, read %d", destPathName, contentLength, totalRead));
            }
        }
        finally {
            if (response != null) {
                HttpClientUtils.closeQuietly((HttpResponse)response);
            }
            if (downloadStream != null) {
                IOUtils.closeQuietly((OutputStream)downloadStream);
            }
        }
    }

    private SessionManager.GenericServiceTicket obtainGenericServiceTicket(String url) {
        SessionManager.HttpServiceRequestSpec spec = new SessionManager.HttpServiceRequestSpec();
        spec.setUrl(url);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("Requesting service ticket for for URL '%s' ...", url));
        }
        SessionManager sessionManager = this._vcClient.getSessionManager();
        SessionManager.GenericServiceTicket serviceTicket = sessionManager.acquireGenericServiceTicket((SessionManager.ServiceRequestSpec)spec);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("Successfully cquired generic service ticket for URL '%s'", spec.getUrl()));
        }
        return serviceTicket;
    }

    private HttpResponse get(String accessUrl, SessionManager.GenericServiceTicket accessTicket) throws IOException {
        try {
            HttpGet httpGet = new HttpGet(accessUrl);
            httpGet.setHeader("Cookie", VMWARE_CGI_TICKET_HEADER + accessTicket.getId());
            HttpResponse response = this._httpClient.execute((HttpUriRequest)httpGet);
            return response;
        }
        catch (Exception e) {
            String message = "FAILED connecting to URL " + accessUrl + ". The configuration data for this host will not be downloaded.";
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)e);
            }
            throw new IOException(message, e);
        }
    }
}

