/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.esx.files.util;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EsxFileLayout {
    public static final String TAB = "\t";
    private static final String FILE_COLLECTION_STAGING_DIRECTORY_NAME = "vmware-datacollector";
    private static final String STORAGE_DIRECTORY_PROPERTY = "PS_BASEDIR";
    private static final String ESX_CFG_INFO_FILENAME = "esxcfg-info.xml";
    private static final String ESX_SUBFOLDER_NAME = "esxcfg";
    private static final String ESX_BUNDLE_NAME = "-esxcfg.zip";
    private static final String VC_SUBFOLDER_NAME = "vc";
    private static final String VC_BUNDLE_NAME = "vc.zip";
    private static final String PERFORMANCE_STATS_FILE_NAME = "performance-stats.txt";
    private static final String WORKING_FOLDER_NAME = "wrk";
    private static final String RTU_FOLDER_NAME = "ready-to-upload";
    private static final Log _log = LogFactory.getLog(EsxFileLayout.class);
    private final File _collectionRootFolder;

    public EsxFileLayout() throws IOException {
        File localStorageFolder = EsxFileLayout.getStorageFolder();
        File stagingFolder = new File(localStorageFolder, FILE_COLLECTION_STAGING_DIRECTORY_NAME);
        this._collectionRootFolder = EsxFileLayout.createCollectionRootFolder(stagingFolder);
    }

    public File getHostCfgInfoFile(ManagedObjectReference hostMoRef) {
        Objects.requireNonNull(hostMoRef);
        File hostWorkFolder = new File(this.getRootWorkFolder(), hostMoRef.getValue());
        File esxCfgSubFolder = new File(hostWorkFolder, ESX_SUBFOLDER_NAME);
        esxCfgSubFolder.mkdirs();
        return new File(esxCfgSubFolder, ESX_CFG_INFO_FILENAME);
    }

    public File getRTUZipFileForHostEsxCfg(ManagedObjectReference hostMoRef) {
        Objects.requireNonNull(hostMoRef);
        File rtuZipFile = new File(this.getReadyToUploadFolder(), hostMoRef.getValue() + ESX_BUNDLE_NAME);
        rtuZipFile.getParentFile().mkdirs();
        return rtuZipFile;
    }

    public File getRTUZipFileForVcData() {
        File rtuZipFile = new File(this.getReadyToUploadFolder(), VC_BUNDLE_NAME);
        rtuZipFile.getParentFile().mkdirs();
        return rtuZipFile;
    }

    public File getPerformanceStatsFile() {
        return new File(this.getRootWorkFolder(), PERFORMANCE_STATS_FILE_NAME);
    }

    public File getVcWorkFolder() {
        File workingFolderForThisVc = new File(this.getRootWorkFolder(), VC_SUBFOLDER_NAME);
        workingFolderForThisVc.mkdirs();
        return workingFolderForThisVc;
    }

    public File getReadyToUploadFolder() {
        File readyToUploadFolder = new File(this._collectionRootFolder, RTU_FOLDER_NAME);
        readyToUploadFolder.mkdirs();
        return readyToUploadFolder;
    }

    public void cleanUp() {
        FileUtils.deleteQuietly((File)this.getRootWorkFolder());
        FileUtils.deleteQuietly((File)this.getReadyToUploadFolder());
    }

    private File getRootWorkFolder() {
        return new File(this._collectionRootFolder, WORKING_FOLDER_NAME);
    }

    private static File getStorageFolder() throws IOException {
        String storageFolderName = System.getProperty(STORAGE_DIRECTORY_PROPERTY);
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Storage target directory from sytem property %s: %s", STORAGE_DIRECTORY_PROPERTY, storageFolderName));
        }
        File storageFolderFile = null;
        if (storageFolderName != null) {
            storageFolderFile = new File(storageFolderName);
        } else {
            storageFolderFile = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
            _log.warn((Object)("Could not find storage directory. Will default to " + storageFolderFile.getAbsolutePath()));
        }
        return storageFolderFile;
    }

    private static File createCollectionRootFolder(File stagingFolder) {
        File collectionRootFolder = new File(stagingFolder, "" + System.currentTimeMillis());
        collectionRootFolder.mkdirs();
        return collectionRootFolder;
    }
}

