/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.esx.files.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JacksonSerializer {
    private static final String JSON_SUFFIX = ".json";
    private static final Log _log = LogFactory.getLog(JacksonSerializer.class);
    private final ObjectMapper _mapper = new ObjectMapper();
    private final ObjectWriter _writer = this._mapper.writerWithDefaultPrettyPrinter();

    public <T> void writeObject(T object, Class<T> clazz, File destFolder) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(destFolder);
        Objects.requireNonNull(object);
        File resultFile = JacksonSerializer.createResultFile(clazz, destFolder);
        try (FileOutputStream jsonOutputStream = new FileOutputStream(resultFile);){
            this._writer.writeValue((OutputStream)jsonOutputStream, object);
        }
        catch (Exception e) {
            String message = "Error serializing object of class '" + clazz.getSimpleName() + "' to folder '" + destFolder + "'. Object = " + object;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)e);
            }
            throw new RuntimeException(message, e);
        }
    }

    private static File createResultFile(Class clazz, File destFolder) {
        return new File(destFolder, clazz.getSimpleName() + JSON_SUFFIX);
    }
}

