/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.esx.files.util.compress;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Tar {
    private static final Log _log = LogFactory.getLog(Tar.class);
    private final List<File> _filesToBundle;

    public Tar(Collection<File> filesToBundle) {
        Objects.requireNonNull(filesToBundle);
        this._filesToBundle = new ArrayList<File>(filesToBundle.size());
        this._filesToBundle.addAll(filesToBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBundle(File bundleFile) throws IOException {
        Objects.requireNonNull(bundleFile);
        if (bundleFile.exists()) {
            throw new IllegalArgumentException("Cannot create tar bundle using destionation " + bundleFile + ", as it already exists.");
        }
        try (TarArchiveOutputStream tarOutputStream = null;){
            tarOutputStream = new TarArchiveOutputStream((OutputStream)new FileOutputStream(bundleFile));
            for (File fileToBundle : this._filesToBundle) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Adding file " + fileToBundle + " to bundle " + bundleFile));
                }
                if (Files.isRegularFile(fileToBundle.toPath(), new LinkOption[0])) {
                    ArchiveEntry entry = tarOutputStream.createArchiveEntry(fileToBundle, fileToBundle.getName());
                    tarOutputStream.putArchiveEntry(entry);
                } else if (_log.isWarnEnabled()) {
                    _log.warn((Object)("File " + fileToBundle + " is not regular. Skipping for TAR bundle creation."));
                }
                FileInputStream input = null;
                try {
                    input = new FileInputStream(fileToBundle);
                    IOUtils.copy((InputStream)input, (OutputStream)tarOutputStream);
                    tarOutputStream.closeArchiveEntry();
                }
                finally {
                    if (input == null) continue;
                    ((InputStream)input).close();
                }
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Tar bundle " + bundleFile + " created successfully. The total size of the bundle is " + bundleFile.length()));
        }
    }
}

