/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.esx.files.util.compress;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Zip {
    private static final String ZIP_PATH_SEPARATOR = "/";
    private static final Log _log = LogFactory.getLog(Zip.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File fileOrFolder, File zipOutputFile) throws IOException {
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            File[] allFiles;
            File[] fileArray;
            fos = new FileOutputStream(zipOutputFile);
            zos = new ZipOutputStream(fos);
            if (fileOrFolder.isFile()) {
                File[] fileArray2 = new File[1];
                fileArray = fileArray2;
                fileArray2[0] = fileOrFolder;
            } else {
                fileArray = allFiles = fileOrFolder.listFiles();
            }
            if (allFiles != null) {
                for (File f : allFiles) {
                    Zip.zip(f, f.getName(), zos);
                }
            }
        }
        finally {
            if (zos != null) {
                zos.close();
            } else if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(File file, String name, ZipOutputStream zos) throws IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    String childName = name + ZIP_PATH_SEPARATOR + f.getName();
                    Zip.zip(f, childName, zos);
                }
            }
        } else if (Files.isRegularFile(file.toPath(), new LinkOption[0])) {
            try (FileInputStream fis = new FileInputStream(file);){
                ZipEntry entry = new ZipEntry(name);
                zos.putNextEntry(entry);
                IOUtils.copy((InputStream)fis, (OutputStream)zos);
            }
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("File " + file.getName() + " is a symbolic link. Skipping for ZIP bundle creation."));
        }
    }
}

