/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.esx.files.util.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.TrustStrategy;

public final class KeyStoreBasedTrustStrategy
implements TrustStrategy {
    private static final Log _log = LogFactory.getLog(KeyStoreBasedTrustStrategy.class);
    private final TrustManagerFactory _trustManagerFactory;

    public KeyStoreBasedTrustStrategy(KeyStore trustStore) {
        this._trustManagerFactory = KeyStoreBasedTrustStrategy.createTrustManagerFactory(trustStore);
    }

    public boolean isTrusted(X509Certificate[] chainToVerify, String authenticationType) throws CertificateException {
        try {
            return KeyStoreBasedTrustStrategy.verifyTrust(chainToVerify, authenticationType, this._trustManagerFactory);
        }
        catch (CertificateException e) {
            KeyStoreBasedTrustStrategy.logUnableToVerifyCertificateChain(chainToVerify, e);
            return false;
        }
    }

    private static boolean verifyTrust(X509Certificate[] chain, String authType, TrustManagerFactory trustManagerFactory) throws CertificateException {
        boolean isTrusted = false;
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            ((X509TrustManager)trustManager).checkServerTrusted(chain, authType);
            isTrusted = true;
            break;
        }
        return isTrusted;
    }

    private static TrustManagerFactory createTrustManagerFactory(KeyStore trustStore) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            return trustManagerFactory;
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            String message = "Unable to load trust store " + trustStore;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message);
            }
            throw new IllegalArgumentException(message);
        }
    }

    private static void logUnableToVerifyCertificateChain(X509Certificate[] certificateChain, Exception exception) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Cannot verify that certificate chain " + Arrays.toString(certificateChain) + " is valid."), (Throwable)exception);
        }
    }
}

