/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.fcd.collector.dataretriever;

import com.vmware.ph.phservice.provider.common.CopyUtil;
import com.vmware.ph.phservice.provider.common.DataRetriever;
import com.vmware.ph.phservice.provider.fcd.collector.customobject.CustomVStorageObjectSnapshotInfo;
import com.vmware.ph.phservice.provider.fcd.collector.dataretriever.FcdDataRetrieverHelper;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.vim.binding.vim.fault.FileFault;
import com.vmware.vim.binding.vim.fault.InvalidDatastore;
import com.vmware.vim.binding.vim.fault.InvalidState;
import com.vmware.vim.binding.vim.fault.NotFound;
import com.vmware.vim.binding.vim.vslm.ID;
import com.vmware.vim.binding.vim.vslm.VStorageObjectSnapshotInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CustomVStorageObjectSnapshotInfoRetriever
implements DataRetriever<CustomVStorageObjectSnapshotInfo> {
    private static final Log log = LogFactory.getLog(CustomVStorageObjectSnapshotInfoRetriever.class);
    private final VcClient _vcClient;
    private final int _queryOffset;
    private final int _queryLimit;

    public CustomVStorageObjectSnapshotInfoRetriever(VcClient vcClient, int queryOffset, int queryLimit) {
        this._vcClient = vcClient;
        this._queryOffset = queryOffset;
        this._queryLimit = queryLimit;
    }

    @Override
    public List<CustomVStorageObjectSnapshotInfo> retrieveData() {
        FcdDataRetrieverHelper fcdDataRetrieverHelper = new FcdDataRetrieverHelper(this._vcClient);
        TreeMap<ID, ManagedObjectReference> fcdIdToDatastoreMap = fcdDataRetrieverHelper.getSortedFcdIdToDatastoreMap();
        int startInd = this._queryOffset;
        int lastInd = Math.min(this._queryOffset + this._queryLimit, fcdIdToDatastoreMap.keySet().size()) - 1;
        ArrayList<CustomVStorageObjectSnapshotInfo> customVsoSnapshotInfoList = new ArrayList<CustomVStorageObjectSnapshotInfo>(lastInd - startInd + 1);
        NavigableSet<ID> fcdIds = fcdIdToDatastoreMap.navigableKeySet();
        int curIndex = 0;
        for (ID id : fcdIds) {
            if (curIndex > lastInd) break;
            if (curIndex >= startInd) {
                try {
                    VStorageObjectSnapshotInfo snapshotInfo = fcdDataRetrieverHelper.getVStorageObjectManager().retrieveSnapshotInfo(id, fcdIdToDatastoreMap.get(id));
                    CustomVStorageObjectSnapshotInfo customVsoSnapshotInfo = new CustomVStorageObjectSnapshotInfo();
                    CopyUtil.copyPublicFields(snapshotInfo, (Object)customVsoSnapshotInfo);
                    customVsoSnapshotInfo.setFcdId(id);
                    customVsoSnapshotInfoList.add(customVsoSnapshotInfo);
                }
                catch (FileFault | InvalidDatastore | InvalidState | NotFound e) {
                    log.warn((Object)"Error occurred while retrieving VStorageObjectSnapshotInfo", e);
                }
            }
            ++curIndex;
        }
        return customVsoSnapshotInfoList;
    }

    @Override
    public String getKey(CustomVStorageObjectSnapshotInfo t) {
        return t.getFcdId().getId();
    }
}

