/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.license;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.ph.phservice.provider.common.DataRetriever;
import com.vmware.ph.phservice.provider.common.PageUtil;
import com.vmware.ph.phservice.provider.license.client.LicenseClient;
import com.vmware.ph.phservice.provider.license.collector.dataretriever.AssetsSpecilizedDataRetreiverImpl;
import com.vmware.ph.phservice.provider.license.collector.dataretriever.LicenseServiceDataRetrieverImpl;
import com.vmware.ph.phservice.provider.vimcommon.VimResourceItem;
import com.vmware.ph.phservice.provider.vimcommon.VmodlTypeToQuerySchemaModelInfoConverter;
import com.vmware.ph.phservice.provider.vimcommon.util.VimDataProviderUtil;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.util.List;
import java.util.Map;

public class LicenseDataProviderImpl
implements DataProvider {
    private static final String ASSET_QUERY_RESOURCE_MODEL = "Asset";
    private final LicenseClient _licenseClient;
    private final VcClient _vcClient;
    private QuerySchema _querySchema;

    public LicenseDataProviderImpl(LicenseClient licenseClient, VcClient vcClient, VmodlContext vmodlContext, Class<?> vmodlClassVersion) {
        this._querySchema = LicenseDataProviderImpl.createQuerySchema(vmodlContext, vmodlClassVersion);
        this._licenseClient = licenseClient;
        this._vcClient = vcClient;
    }

    public QuerySchema getSchema() {
        return this._querySchema;
    }

    public ResultSet executeQuery(Query query) {
        String queryResourceModel = (String)query.getResourceModels().iterator().next();
        DataRetriever<Object> dataRetriever = null;
        dataRetriever = queryResourceModel.equals(ASSET_QUERY_RESOURCE_MODEL) ? new AssetsSpecilizedDataRetreiverImpl(this._licenseClient, this._vcClient) : new LicenseServiceDataRetrieverImpl(this._licenseClient, queryResourceModel);
        List<VimResourceItem> licenseResourceItems = VimDataProviderUtil.getVimResourceItems(query.getProperties(), dataRetriever);
        licenseResourceItems = PageUtil.pageItems(licenseResourceItems, query.getOffset(), query.getLimit());
        ResultSet resultSet = VimDataProviderUtil.convertVimResourceItemsToResultSet(licenseResourceItems, query.getProperties());
        return resultSet;
    }

    private static QuerySchema createQuerySchema(VmodlContext vmodlContext, Class<?> vmodlClassVersion) {
        VmodlTypeMap vmodlTypeMap = vmodlContext.getVmodlTypeMap();
        VmodlVersion vmodlVersion = vmodlContext.getVmodlVersionMap().getVersion(vmodlClassVersion);
        List<VmodlType> dataObjectVmodlTypes = VmodlTypeToQuerySchemaModelInfoConverter.getAllDataObjectVmodlTypesInPackage(vmodlTypeMap, "com.vmware.vim.binding.cis.license");
        Map<String, QuerySchema.ModelInfo> typeNameToModelInfo = VmodlTypeToQuerySchemaModelInfoConverter.convertVmodlTypesToClassNameModelInfos(dataObjectVmodlTypes, vmodlTypeMap, vmodlVersion);
        QuerySchema querySchema = QuerySchema.forModels(typeNameToModelInfo);
        return querySchema;
    }
}

