/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.license;

import com.vmware.cis.data.provider.DataProvider;
import com.vmware.ph.phservice.ciscommon.lookup.LookupClient;
import com.vmware.ph.phservice.provider.license.LicenseDataProviderImpl;
import com.vmware.ph.phservice.provider.license.client.LicenseClient;
import com.vmware.ph.phservice.provider.license.client.LicenseClientBuilder;
import com.vmware.ph.phservice.provider.vimcommon.VimContext;
import com.vmware.ph.phservice.provider.vimcommon.VimDataProvidersConnection;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClientProvider;
import com.vmware.ph.phservice.vmomicommon.VmodlContextProvider;
import com.vmware.vim.binding.cis.license.License;
import com.vmware.vim.binding.cis.license.version.internal.version2;
import com.vmware.vim.binding.lookup.LookupService;
import com.vmware.vim.binding.lookup.SearchCriteria;
import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.binding.lookup.ServiceEndpoint;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class LicenseDataProvidersConnection
extends VimDataProvidersConnection {
    private static final Class<?> LICENSE_VMODL_BINDINGS_VERSION = version2.class;
    private static final String LICENSE_SERVICE_TYPE_NAME = "urn:cs.license";
    private static final String LICENSE_SERVICE_SDK_PATH = "/ls/sdk";
    static final String LICENSE_VMODL_PACKAGE_NAME = "com.vmware.vim.binding.cis.license";
    private LicenseClient _licenseClient;
    private DataProvider _licenseDataProvider;
    private ExecutorService _executorService;

    public LicenseDataProvidersConnection(VimContext vimContext) {
        super(vimContext);
    }

    public LicenseDataProvidersConnection(VimContext vimContext, VcClientProvider vcClientProvider) {
        super(vimContext, vcClientProvider);
    }

    @Override
    public synchronized List<DataProvider> getDataProviders() throws Exception {
        if (this._licenseDataProvider == null) {
            this.createLicenseDataProvider();
        }
        return Collections.singletonList(this._licenseDataProvider);
    }

    @Override
    public synchronized void close() {
        if (this._licenseClient != null) {
            this._licenseClient.logout();
            this._licenseClient.close();
            this._licenseClient = null;
        }
        if (this._executorService != null) {
            this._executorService.shutdown();
            this._executorService = null;
        }
        this._licenseDataProvider = null;
        super.close();
    }

    private void createLicenseDataProvider() throws Exception {
        VmodlContext vmodlContext = VmodlContextProvider.getVmodlContextForPacakgeAndClass(LICENSE_VMODL_PACKAGE_NAME, License.class, false);
        this._executorService = Executors.newSingleThreadExecutor();
        LicenseClientBuilder licenseClientBuilder = LicenseClientBuilder.forLicenseClient(LICENSE_VMODL_BINDINGS_VERSION, this._executorService);
        URI licenseServiceSdkUri = this.discoverLicenseServiceSdkUri();
        if (licenseServiceSdkUri == null) {
            throw new IllegalStateException("The license service SDK URI was not discovered!");
        }
        this._licenseClient = licenseClientBuilder.withSdkUri(licenseServiceSdkUri).withTrustStore(this._vimContext.getVimTrustedStore()).withThumbprintVerifier(this._vimContext.getThumprintVerifier()).withSsoTokenProvider(this._vimContext.getSsoTokenProvider()).build();
        this._licenseDataProvider = new LicenseDataProviderImpl(this._licenseClient, this.getVcClient(), vmodlContext, LICENSE_VMODL_BINDINGS_VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI discoverLicenseServiceSdkUri() throws Exception {
        try (LookupClient lookupClient = this._vimContext.getLookupClientBuilder(false).build();){
            LookupService lookupService = lookupClient.getLookupService();
            Service[] services = lookupService.find(new SearchCriteria(new URI(LICENSE_SERVICE_TYPE_NAME), lookupService.getViSite(), ServiceEndpoint.EndpointProtocol.vmomi.toString()));
            if (services == null) {
                URI uRI = null;
                return uRI;
            }
            URI licenseServiceSdkUri = null;
            ServiceEndpoint[] serviceEndpoints = services[0].getEndpoints();
            if (serviceEndpoints == null) {
                URI uRI = null;
                return uRI;
            }
            for (ServiceEndpoint serviceEndpoint : serviceEndpoints) {
                if (!serviceEndpoint.getUrl().getPath().equals(LICENSE_SERVICE_SDK_PATH)) continue;
                licenseServiceSdkUri = serviceEndpoint.getUrl();
                break;
            }
            URI uRI = licenseServiceSdkUri;
            return uRI;
        }
    }
}

