/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.license.collector.dataretriever;

import com.vmware.ph.phservice.provider.common.DataRetriever;
import com.vmware.ph.phservice.provider.common.PageUtil;
import com.vmware.ph.phservice.provider.license.client.LicenseClient;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.ph.phservice.provider.vimcommon.vc.util.HostReader;
import com.vmware.vim.binding.cis.license.Asset;
import com.vmware.vim.binding.cis.license.AssetIdentifier;
import com.vmware.vim.binding.cis.license.AssetInfo;
import com.vmware.vim.binding.cis.license.License;
import com.vmware.vim.binding.cis.license.LicenseInfo;
import com.vmware.vim.binding.cis.license.SerialKeyLicenseInfo;
import com.vmware.vim.binding.cis.license.fault.NotFoundFault;
import com.vmware.vim.binding.cis.license.management.AssetSearchSpec;
import com.vmware.vim.binding.cis.license.management.SystemManagementService;
import com.vmware.vim.binding.impl.cis.license.AssetIdentifierImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByIdentifiersImpl;
import com.vmware.vim.binding.impl.cis.license.management.AssetSearchSpecByProductFamilyNamesImpl;
import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.exception.ConnectionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AssetsSpecilizedDataRetreiverImpl
implements DataRetriever<Asset> {
    private static final String ESX_SERVER_PRODUCT_FAMILY_NAME = "VMware ESX Server";
    private static final String VC_SERVER_PRODUCT_FAMILY_NAME = "VMware VirtualCenter Server";
    private static final int ESX_PAGE_SIZE = 200;
    private static final int ESX_OPTIMIZATION_THRESHOLD = 600;
    private static final String EVALUATION_LICENSE_KEY = "00000-00000-00000-00000-00000";
    private static final String NO_LICENSE_KEY = "";
    private static final String VC_ID_PROPERTY = "vcId";
    private static final String LICENSE_SERIAL_KEY_PROPERTY = "licenseKey";
    private static final Log _log = LogFactory.getLog(AssetsSpecilizedDataRetreiverImpl.class);
    private final LicenseClient _licenseClient;
    private final VcClient _vcClient;
    private final HostReader _hostReader;

    public AssetsSpecilizedDataRetreiverImpl(LicenseClient licenseClient, VcClient vcClient) {
        this._licenseClient = licenseClient;
        this._vcClient = vcClient;
        this._hostReader = new HostReader(this._vcClient);
    }

    @Override
    public List<Asset> retrieveData() {
        HashMap<String, String> vcScopeToVcInstanceIdMap = new HashMap<String, String>();
        ArrayList<Asset> retrievedAssets = new ArrayList<Asset>();
        List<Asset> vcAssets = this.searchAssetsByProductFamilyName(new String[]{VC_SERVER_PRODUCT_FAMILY_NAME}, false, null);
        for (Asset vcAsset : vcAssets) {
            AssetInfo vcAssetInfo = vcAsset.getInfo();
            vcScopeToVcInstanceIdMap.put(vcAssetInfo.getScopeId(), vcAssetInfo.getInstanceId());
        }
        retrievedAssets.addAll(AssetsSpecilizedDataRetreiverImpl.augmentAssets(vcAssets, vcScopeToVcInstanceIdMap));
        List<Asset> nonVcAndEsxAssets = this.searchAssetsByProductFamilyName(new String[]{ESX_SERVER_PRODUCT_FAMILY_NAME, VC_SERVER_PRODUCT_FAMILY_NAME}, true, null);
        retrievedAssets.addAll(AssetsSpecilizedDataRetreiverImpl.augmentAssets(nonVcAndEsxAssets, vcScopeToVcInstanceIdMap));
        String givenVcInstanceId = this._vcClient.getServiceInstanceContent().getAbout().getInstanceUuid();
        for (Asset vcAsset : vcAssets) {
            AssetInfo vcAssetInfo = vcAsset.getInfo();
            if (!givenVcInstanceId.equals(vcAssetInfo.getInstanceId())) continue;
            List<Asset> esxAssets = this.searchEsxAssetsInVc(vcAssetInfo.getInstanceId(), vcAssetInfo.getScopeId());
            retrievedAssets.addAll(AssetsSpecilizedDataRetreiverImpl.augmentAssets(esxAssets, vcScopeToVcInstanceIdMap));
        }
        return retrievedAssets;
    }

    @Override
    public String getKey(Asset asset) {
        return asset.getId().toString();
    }

    private List<Asset> searchAssetsByProductFamilyName(String[] productFamilyNames, boolean isInverseSearch, String scopeId) {
        AssetSearchSpecByProductFamilyNamesImpl assetSearchSpec = new AssetSearchSpecByProductFamilyNamesImpl();
        assetSearchSpec.setProductFamilyNames(productFamilyNames);
        assetSearchSpec.setInverseSearch(Boolean.valueOf(isInverseSearch));
        if (scopeId != null) {
            assetSearchSpec.setScopeId(scopeId);
        }
        List<Asset> assetsAsList = this.searchAssets((AssetSearchSpec)assetSearchSpec);
        return assetsAsList;
    }

    private List<Asset> searchAssets(AssetSearchSpec assetSearchSpec) {
        Asset[] assets;
        block4: {
            SystemManagementService systemManagementService = this._licenseClient.getSystemManagementService();
            assets = null;
            try {
                assets = systemManagementService.searchAssets(assetSearchSpec);
            }
            catch (ConnectionException ce) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Connection problem was caught while trying to search for assets. This means that no telemetry data for assets will be collected.", (Throwable)ce);
                }
            }
            catch (NotFoundFault e) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)"Asset not found.", (Throwable)e);
            }
        }
        List<Object> assetsAsList = null;
        assetsAsList = assets != null ? Arrays.asList(assets) : Collections.emptyList();
        return assetsAsList;
    }

    private List<Asset> searchEsxAssetsInVc(String vcInstanceId, String vcNodeId) {
        List<ManagedObjectReference> hostMoRefs;
        List<Asset> assets = null;
        String givenVcInstanceId = this._vcClient.getServiceInstanceContent().getAbout().getInstanceUuid();
        if (vcInstanceId.equals(givenVcInstanceId) && (hostMoRefs = this._hostReader.getHostMoRefs()).size() > 600) {
            assets = this.searchEsxAssetsByHostMoRefsWithPaging(hostMoRefs, vcNodeId);
        }
        if (assets == null) {
            assets = this.searchAssetsByProductFamilyName(new String[]{ESX_SERVER_PRODUCT_FAMILY_NAME}, false, vcNodeId);
        }
        return assets;
    }

    private List<Asset> searchEsxAssetsByHostMoRefsWithPaging(List<ManagedObjectReference> hostMoRefs, String vcNodeId) {
        ArrayList<Asset> hostAssets = new ArrayList<Asset>();
        List<Integer> pageOffsets = PageUtil.getPagesOffsets(hostMoRefs.size(), 200);
        for (int pageOffset : pageOffsets) {
            List<ManagedObjectReference> pagedHostMoRefs = PageUtil.pageItems(hostMoRefs, pageOffset, 200);
            List<Asset> pagedHostAssets = this.searchEsxAssetsByHostMoRefs(pagedHostMoRefs, vcNodeId);
            hostAssets.addAll(pagedHostAssets);
        }
        return hostAssets;
    }

    private List<Asset> searchEsxAssetsByHostMoRefs(List<ManagedObjectReference> hostMoRefs, String vcNodeId) {
        List<AssetIdentifier> hostAssetIdentifiers = AssetsSpecilizedDataRetreiverImpl.createAssetIdentifiersFromHostMoRefs(hostMoRefs, vcNodeId);
        AssetSearchSpecByIdentifiersImpl searchSpec = new AssetSearchSpecByIdentifiersImpl();
        searchSpec.setScopeId(vcNodeId);
        searchSpec.setAssetIdentifiers(hostAssetIdentifiers.toArray(new AssetIdentifier[hostAssetIdentifiers.size()]));
        List<Asset> hostAssets = this.searchAssets((AssetSearchSpec)searchSpec);
        return hostAssets;
    }

    private static List<AssetIdentifier> createAssetIdentifiersFromHostMoRefs(List<ManagedObjectReference> hostMoRefs, String vcNodeId) {
        ArrayList<AssetIdentifier> assetIdentifiers = new ArrayList<AssetIdentifier>();
        for (ManagedObjectReference hostMoRef : hostMoRefs) {
            AssetIdentifierImpl assetIdentifier = new AssetIdentifierImpl();
            assetIdentifier.setInstanceId(hostMoRef.getValue());
            assetIdentifier.setScopeId(vcNodeId);
            assetIdentifiers.add((AssetIdentifier)assetIdentifier);
        }
        return assetIdentifiers;
    }

    private static List<Asset> augmentAssets(List<Asset> assets, Map<String, String> vcScopeToVcInstanceIdMap) {
        List<Asset> augmentedAssets = AssetsSpecilizedDataRetreiverImpl.augmentAssetsWithVcId(assets, vcScopeToVcInstanceIdMap);
        augmentedAssets = AssetsSpecilizedDataRetreiverImpl.augmentAssetsWithLicenseSerialKey(augmentedAssets);
        return augmentedAssets;
    }

    private static List<Asset> augmentAssetsWithVcId(List<Asset> assets, Map<String, String> vcScopeToVcInstanceIdMap) {
        for (Asset asset : assets) {
            String assetScopeId = asset.getInfo().getScopeId();
            String discoveredVcInstnaceId = null;
            if (assetScopeId != null) {
                discoveredVcInstnaceId = vcScopeToVcInstanceIdMap.get(assetScopeId);
            }
            AssetsSpecilizedDataRetreiverImpl.setAssetProperty(asset, VC_ID_PROPERTY, discoveredVcInstnaceId);
        }
        return assets;
    }

    private static List<Asset> augmentAssetsWithLicenseSerialKey(List<Asset> assets) {
        String licenseKey = NO_LICENSE_KEY;
        for (Asset asset : assets) {
            AssetInfo assetInfo = asset.getInfo();
            if (assetInfo.isInEvaluation()) {
                licenseKey = EVALUATION_LICENSE_KEY;
            } else {
                License license = assetInfo.getLicense();
                if (license != null) {
                    LicenseInfo licenseInfo = license.getInfo();
                    licenseKey = AssetsSpecilizedDataRetreiverImpl.extractSerialKey(licenseInfo);
                }
            }
            AssetsSpecilizedDataRetreiverImpl.setAssetProperty(asset, LICENSE_SERIAL_KEY_PROPERTY, licenseKey);
        }
        return assets;
    }

    private static String extractSerialKey(LicenseInfo licenseInfo) {
        if (licenseInfo instanceof SerialKeyLicenseInfo) {
            SerialKeyLicenseInfo serialKeyLicenseInfo = (SerialKeyLicenseInfo)licenseInfo;
            String[] serialKeys = serialKeyLicenseInfo.getSerialKeys();
            assert (serialKeys != null && serialKeys.length > 0);
            return serialKeys[0];
        }
        return NO_LICENSE_KEY;
    }

    private static void setAssetProperty(Asset asset, String key, Object value) {
        AssetInfo assetInfo = asset.getInfo();
        KeyAnyValueImpl assetProperty = new KeyAnyValueImpl();
        assetProperty.setKey(key);
        if (value == null) {
            assetProperty.setValue(null);
        } else {
            assetProperty.setValue(value);
        }
        KeyAnyValue[] assetProperties = assetInfo.getProperties();
        KeyAnyValue[] modifiedAssetProperties = null;
        int numProperties = 0;
        if (assetProperties == null) {
            modifiedAssetProperties = new KeyAnyValue[1];
        } else {
            numProperties = assetProperties.length;
            modifiedAssetProperties = new KeyAnyValue[numProperties + 1];
            System.arraycopy(assetProperties, 0, modifiedAssetProperties, 0, numProperties);
        }
        modifiedAssetProperties[numProperties] = assetProperty;
        assetInfo.setProperties(modifiedAssetProperties);
    }
}

