/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.license.collector.dataretriever;

import com.vmware.ph.phservice.provider.common.DataRetriever;
import com.vmware.ph.phservice.provider.license.client.LicenseClient;
import com.vmware.ph.phservice.provider.vimcommon.util.VimDataProviderUtil;
import com.vmware.vim.binding.cis.license.management.SystemManagementService;
import com.vmware.vim.vmomi.client.exception.ConnectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LicenseServiceDataRetrieverImpl
implements DataRetriever<Object> {
    private static final String SEARCH_METHOD_TEMPLATE = "search%ss";
    private static final int SINGLE_PARAMETER = 1;
    private static final String ID_PROPERTY = "id";
    private static final Map<String, String> ID_PROPERTY_MAP;
    private static final Log _log;
    private final LicenseClient _licenseClient;
    private final String _resourceModelType;

    public LicenseServiceDataRetrieverImpl(LicenseClient licenseClient, String resourceModelType) {
        this._licenseClient = licenseClient;
        this._resourceModelType = resourceModelType;
    }

    @Override
    public List<Object> retrieveData() {
        Object[] retrievedObjects = this.searchForResourceModelObjects();
        List<Object> retrievedData = null;
        retrievedData = retrievedObjects != null ? Arrays.asList(retrievedObjects) : Collections.emptyList();
        return retrievedData;
    }

    @Override
    public String getKey(Object vmodlObject) {
        String propertyName = ID_PROPERTY_MAP.get(vmodlObject.getClass().getSimpleName());
        if (propertyName == null) {
            propertyName = ID_PROPERTY;
        }
        Object key = VimDataProviderUtil.getPropertyValue(vmodlObject, propertyName);
        return key.toString();
    }

    private Object[] searchForResourceModelObjects() {
        Object[] dataObjects;
        block5: {
            dataObjects = null;
            try {
                Method searchMethod = this.acquireSearchMethod();
                if (searchMethod != null) {
                    dataObjects = (Object[])searchMethod.invoke((Object)this._licenseClient.getSystemManagementService(), new Object[]{null});
                } else if (_log.isDebugEnabled()) {
                    _log.debug((Object)String.format("Cannot find search method for resource model %s", this._resourceModelType));
                }
            }
            catch (ConnectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Object)String.format("Invoking the search method for resource %s failed", this._resourceModelType), e);
            }
        }
        return dataObjects;
    }

    private Method acquireSearchMethod() {
        String targetSearchMethodName = String.format(SEARCH_METHOD_TEMPLATE, this._resourceModelType);
        Class<SystemManagementService> systemManagementServiceClass = SystemManagementService.class;
        Method[] systemManagementServiceMethods = systemManagementServiceClass.getMethods();
        if (systemManagementServiceMethods == null) {
            return null;
        }
        Method searchMethod = null;
        for (Method method : systemManagementServiceMethods) {
            if (!method.getName().equals(targetSearchMethodName) || method.getParameterTypes().length != 1) continue;
            searchMethod = method;
            break;
        }
        return searchMethod;
    }

    static {
        _log = LogFactory.getLog(LicenseServiceDataRetrieverImpl.class);
        ID_PROPERTY_MAP = new HashMap<String, String>();
        ID_PROPERTY_MAP.put("LicenseUtilizationImpl", "license/id");
        ID_PROPERTY_MAP.put("ProductUtilizationImpl", "product/id");
    }
}

