/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.spbm;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.ph.phservice.provider.common.DataRetriever;
import com.vmware.ph.phservice.provider.common.PageUtil;
import com.vmware.ph.phservice.provider.common.QuerySchemaUtil;
import com.vmware.ph.phservice.provider.spbm.client.XServiceClient;
import com.vmware.ph.phservice.provider.spbm.client.pbm.PbmServiceClient;
import com.vmware.ph.phservice.provider.spbm.client.sms.SmsServiceClient;
import com.vmware.ph.phservice.provider.spbm.collector.SpbmCollectorContext;
import com.vmware.ph.phservice.provider.spbm.collector.customobject.sms.CustomFaultDomainInfo;
import com.vmware.ph.phservice.provider.spbm.collector.dataretriever.DataRetrieverFactory;
import com.vmware.ph.phservice.provider.spbm.collector.schema.SpbmCustomObjectSchemaGenerator;
import com.vmware.ph.phservice.provider.vimcommon.VimResourceItem;
import com.vmware.ph.phservice.provider.vimcommon.VmodlTypeToQuerySchemaModelInfoConverter;
import com.vmware.ph.phservice.provider.vimcommon.util.VimDataProviderUtil;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SpbmDataProviderImpl
implements DataProvider {
    private final SpbmCollectorContext _spbmCollectorContext;
    private final QuerySchema _supportedQuerySchema;

    public SpbmDataProviderImpl(SpbmCollectorContext spbmCollectorContext) {
        this._spbmCollectorContext = spbmCollectorContext;
        this._supportedQuerySchema = this.getSupportedSchema();
    }

    public ResultSet executeQuery(Query query) {
        String resourceModel = (String)query.getResourceModels().iterator().next();
        List queryProperties = query.getProperties();
        List<String> supportedQueryProperties = QuerySchemaUtil.getSupportedQueryPropertyNames(resourceModel, queryProperties, this._supportedQuerySchema);
        List<String> supportedNonQualifiedQueryProperties = QuerySchemaUtil.getNonQualifiedPropertyNames(supportedQueryProperties);
        DataRetriever dataRetriever = DataRetrieverFactory.getDataRetreiver(this._spbmCollectorContext, query);
        List<Object> spbmData = dataRetriever.retrieveData();
        List<VimResourceItem> spbmResourceItems = VimDataProviderUtil.getVimResourceItems(spbmData, supportedNonQualifiedQueryProperties, dataRetriever);
        if (spbmResourceItems.size() > query.getLimit()) {
            spbmResourceItems = PageUtil.pageItems(spbmResourceItems, query.getOffset(), query.getLimit());
        }
        ResultSet resultSet = VimDataProviderUtil.convertVimResourceItemsToResultSet(spbmResourceItems, queryProperties, supportedNonQualifiedQueryProperties);
        return resultSet;
    }

    public QuerySchema getSchema() {
        return this._supportedQuerySchema;
    }

    private QuerySchema getSupportedSchema() {
        LinkedHashMap<String, QuerySchema.ModelInfo> models = new LinkedHashMap<String, QuerySchema.ModelInfo>();
        PbmServiceClient pbmServiceClient = this._spbmCollectorContext.getPbmServiceClient();
        models.putAll(this.getVmodlQuerySchemaModels(pbmServiceClient, "com.vmware.vim.binding.pbm"));
        SmsServiceClient smsServiceClient = this._spbmCollectorContext.getSmsServiceClient();
        models.putAll(this.getVmodlQuerySchemaModels(smsServiceClient, "com.vmware.vim.binding.sms"));
        models.putAll(this.getSmsCustomObjectsSchema(smsServiceClient));
        return QuerySchema.forModels(models);
    }

    private Map<String, QuerySchema.ModelInfo> getVmodlQuerySchemaModels(XServiceClient xServiceClient, String packageName) {
        LinkedHashMap<String, QuerySchema.ModelInfo> models = new LinkedHashMap<String, QuerySchema.ModelInfo>();
        VmodlTypeMap vmodlTypeMap = xServiceClient.getVmodlContext().getVmodlTypeMap();
        VmodlVersion vmodlVersion = xServiceClient.getVmodlVersion();
        List<VmodlType> dataObjecVmodlTypes = VmodlTypeToQuerySchemaModelInfoConverter.getAllDataObjectVmodlTypesInPackage(vmodlTypeMap, packageName);
        models.putAll(VmodlTypeToQuerySchemaModelInfoConverter.convertVmodlTypesToClassNameModelInfos(dataObjecVmodlTypes, vmodlTypeMap, vmodlVersion));
        return models;
    }

    private Map<String, QuerySchema.ModelInfo> getSmsCustomObjectsSchema(SmsServiceClient smsServiceClient) {
        HashSet customEntities = new HashSet();
        customEntities.add(CustomFaultDomainInfo.class);
        return this.getCustomObjectSchema(smsServiceClient, customEntities);
    }

    private Map<String, QuerySchema.ModelInfo> getCustomObjectSchema(XServiceClient xServiceClient, Set<Class<?>> schemaClasses) {
        SpbmCustomObjectSchemaGenerator customObjectSchemaGenerator = new SpbmCustomObjectSchemaGenerator(xServiceClient.getVmodlContext().getVmodlTypeMap(), xServiceClient.getVmodlVersion(), schemaClasses);
        return customObjectSchemaGenerator.getQuerySchemaModel();
    }
}

