/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.spbm.client.common.context;

import com.vmware.ph.phservice.provider.common.Builder;
import com.vmware.ph.phservice.provider.spbm.client.common.context.XServiceClientContext;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.util.Validate;
import java.security.KeyStore;
import java.util.Map;
import java.util.concurrent.Executor;

public class XServiceClientContextBuilder
implements Builder<XServiceClientContext> {
    private final VcClient vcClient;
    private Map<String, Class<?>> vmodlPackageNameToPackageClass;
    private Executor executor;
    private Integer maxConnections;
    private ThumbprintVerifier thumbprintVerifier;
    private Integer timeoutMs;
    private KeyStore trustStore;
    private Class<?> xClientVmodlVersion;

    private XServiceClientContextBuilder(VcClient vcClient) {
        this.vcClient = vcClient;
    }

    public static XServiceClientContextBuilder newInstance(VcClient vcClient) {
        return new XServiceClientContextBuilder(vcClient);
    }

    public XServiceClientContextBuilder withMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public XServiceClientContextBuilder withThumbprintVerifier(ThumbprintVerifier thumbprintVerifier) {
        this.thumbprintVerifier = thumbprintVerifier;
        return this;
    }

    public XServiceClientContextBuilder withTimeoutMs(Integer timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
    }

    public XServiceClientContextBuilder withTrustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
        return this;
    }

    public XServiceClientContextBuilder withXClientVmodlVersion(Class<?> xClientVmodlVersion) {
        this.xClientVmodlVersion = xClientVmodlVersion;
        return this;
    }

    public XServiceClientContextBuilder withVmodlPackageNameToPackageClass(Map<String, Class<?>> vmodlPackageNameToPackageClass) {
        this.vmodlPackageNameToPackageClass = vmodlPackageNameToPackageClass;
        return this;
    }

    public XServiceClientContextBuilder withExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    @Override
    public XServiceClientContext build() {
        Validate.notNull((String)"Failed to create Extension due to missing VC context.", (Object)this.vcClient);
        XServiceClientContext xServiceClientContext = new XServiceClientContext(this.vcClient);
        xServiceClientContext.setExecutor(this.executor);
        xServiceClientContext.setMaxConnections(this.maxConnections);
        xServiceClientContext.setThumbprintVerifier(this.thumbprintVerifier);
        xServiceClientContext.setTimeoutMs(this.timeoutMs);
        xServiceClientContext.setTrustStore(this.trustStore);
        xServiceClientContext.setVmodlPackages(this.vmodlPackageNameToPackageClass);
        xServiceClientContext.setxClientVmodlVersion(this.xClientVmodlVersion);
        return xServiceClientContext;
    }
}

