/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.spbm.client.impl;

import com.vmware.ph.phservice.provider.spbm.client.XServiceClient;
import com.vmware.ph.phservice.provider.spbm.client.XServiceClientFactory;
import com.vmware.ph.phservice.provider.spbm.client.common.context.XServiceClientContext;
import com.vmware.ph.phservice.provider.spbm.client.pbm.PbmServiceClient;
import com.vmware.ph.phservice.provider.spbm.client.pbm.impl.PbmServiceClientImpl;
import com.vmware.ph.phservice.provider.spbm.client.sms.SmsServiceClient;
import com.vmware.ph.phservice.provider.spbm.client.sms.impl.SmsServiceClientImpl;
import com.vmware.ph.phservice.vmomicommon.VmodlContextProvider;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.fault.NoPermission;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vim.vmomi.client.ext.RequestRetryCallback;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationImpl;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XServiceClientFactoryImpl
implements XServiceClientFactory {
    private static final Log log = LogFactory.getLog(XServiceClientFactoryImpl.class);

    @Override
    public PbmServiceClient getPbmServiceClient(XServiceClientContext xServiceClientContext) {
        PbmServiceClient pbmServiceClient = null;
        URI pbmServiceUri = URI.create(xServiceClientContext.getVcClient().getServiceUri().toString().replace("/sdk", "/pbm/sdk"));
        if (log.isTraceEnabled()) {
            log.trace((Object)("Connecting to pbmServiceUri :" + pbmServiceUri.toString()));
        }
        VmodlContextProvider.getVmodlContextForPacakgeAndClass(xServiceClientContext.getVmodlPackageNameToPackageClass(), false);
        pbmServiceClient = XServiceClientFactoryImpl.createPbmServiceClient(pbmServiceUri, xServiceClientContext);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Successfully Connected to pbmServiceUri :" + pbmServiceUri.toString()));
        }
        return pbmServiceClient;
    }

    @Override
    public SmsServiceClient getSmsServiceClient(XServiceClientContext xServiceClientContext) {
        SmsServiceClient smsServiceClient = null;
        URI smsServiceUri = URI.create(xServiceClientContext.getVcClient().getServiceUri().toString().replace("/sdk", "/sms/sdk"));
        if (log.isTraceEnabled()) {
            log.trace((Object)("Connecting to smsServiceUri :" + smsServiceUri.toString()));
        }
        VmodlContextProvider.getVmodlContextForPacakgeAndClass(xServiceClientContext.getVmodlPackageNameToPackageClass(), false);
        smsServiceClient = XServiceClientFactoryImpl.createSmsServiceClient(smsServiceUri, xServiceClientContext);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Successfully Connected to smsServiceUri :" + smsServiceUri.toString()));
        }
        return smsServiceClient;
    }

    private static Client createVmomiClient(URI xServiceUri, RequestRetryCallback requestRetryCallback, XServiceClientContext xServiceClientContext) {
        HttpConfigurationImpl httpConfig = new HttpConfigurationImpl();
        httpConfig.setTrustStore(xServiceClientContext.getTrustStore());
        httpConfig.setThumbprintVerifier(xServiceClientContext.getThumbprintVerifier());
        httpConfig.setCheckStaleConnection(true);
        if (xServiceClientContext.getTimeoutMs() != null) {
            httpConfig.setTimeoutMs(xServiceClientContext.getTimeoutMs().intValue());
        }
        if (xServiceClientContext.getMaxConnections() != null) {
            httpConfig.setMaxConnections(xServiceClientContext.getMaxConnections().intValue());
        }
        HttpClientConfiguration clientConfig = HttpClientConfiguration.Factory.newInstance();
        clientConfig.setExecutor(xServiceClientContext.getExecutor());
        clientConfig.setHttpConfiguration((HttpConfiguration)httpConfig);
        clientConfig.setRequestRetryCallback(requestRetryCallback);
        Client xVmomiClient = Client.Factory.createClient((URI)xServiceUri, xServiceClientContext.getxClientVmodlVersion(), (ClientConfiguration)clientConfig);
        return xVmomiClient;
    }

    private static void setSessionId(Client xVmomiClient, Client vcVmomiClient) {
        if (xVmomiClient != null && vcVmomiClient != null && vcVmomiClient.getBinding().getSession() != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Retrieving a valid session cookie for extension client " + xVmomiClient.getBinding().getEndpointUri()));
            }
            String vcSessionId = vcVmomiClient.getBinding().getSession().getId();
            xVmomiClient.getBinding().setSession(xVmomiClient.getBinding().createSession(vcSessionId));
        }
    }

    private static PbmServiceClient createPbmServiceClient(URI xServiceUri, XServiceClientContext xServiceClientContext) {
        XServiceRequestRetryCallbackImpl requestRetryCallback = new XServiceRequestRetryCallbackImpl();
        Client xVmomiClient = XServiceClientFactoryImpl.createVmomiClient(xServiceUri, requestRetryCallback, xServiceClientContext);
        PbmServiceClientImpl pbmServiceClient = new PbmServiceClientImpl(xVmomiClient, xServiceClientContext);
        XServiceClientFactoryImpl.setSessionId(pbmServiceClient.getVmomiClient(), xServiceClientContext.getVcClient().getVlsiClient());
        requestRetryCallback.setXServiceClient(pbmServiceClient);
        return pbmServiceClient;
    }

    private static SmsServiceClient createSmsServiceClient(URI xServiceUri, XServiceClientContext xServiceClientContext) {
        XServiceRequestRetryCallbackImpl requestRetryCallback = new XServiceRequestRetryCallbackImpl();
        Client xVmomiClient = XServiceClientFactoryImpl.createVmomiClient(xServiceUri, requestRetryCallback, xServiceClientContext);
        SmsServiceClientImpl smsServiceClient = new SmsServiceClientImpl(xVmomiClient, xServiceClientContext);
        XServiceClientFactoryImpl.setSessionId(smsServiceClient.getVmomiClient(), xServiceClientContext.getVcClient().getVlsiClient());
        requestRetryCallback.setXServiceClient(smsServiceClient);
        return smsServiceClient;
    }

    private static class XServiceRequestRetryCallbackImpl
    implements RequestRetryCallback {
        private static final Log log = LogFactory.getLog(XServiceRequestRetryCallbackImpl.class);
        private XServiceClient xServiceClient;

        private XServiceRequestRetryCallbackImpl() {
        }

        public void setXServiceClient(XServiceClient xServiceClient) {
            this.xServiceClient = xServiceClient;
        }

        public boolean retry(Exception exception, InvocationContext context, int count) {
            if (!(exception instanceof NoPermission)) {
                return false;
            }
            if (count > 1) {
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Extension client's session is not authenticated. Re-logging into VC");
            }
            this.callVimApiToInvokeVcRetryCallBack();
            XServiceClientFactoryImpl.setSessionId(this.xServiceClient.getVmomiClient(), this.xServiceClient.getVcClient().getVlsiClient());
            context.getStubRequestContext().put((Object)"vcSessionCookie", (Object)this.xServiceClient.getVmomiClient().getBinding().getSession().getId());
            return true;
        }

        private void callVimApiToInvokeVcRetryCallBack() {
            ManagedObjectReference serviceInstanceMoRef = new ManagedObjectReference("ServiceInstance", "ServiceInstance");
            ServiceInstance serviceInstance = (ServiceInstance)this.xServiceClient.getVcClient().createMo(serviceInstanceMoRef);
            serviceInstance.currentTime();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully logged into VC");
            }
        }
    }
}

