/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.spbm.collector.dataretriever;

import com.vmware.ph.phservice.provider.common.DataRetriever;
import com.vmware.ph.phservice.provider.spbm.client.pbm.PbmServiceClient;
import com.vmware.ph.phservice.provider.spbm.collector.SpbmCollectorContext;
import com.vmware.vim.binding.pbm.profile.CapabilityBasedProfile;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.pbm.profile.ProfileId;
import com.vmware.vim.binding.pbm.profile.ProfileManager;
import com.vmware.vim.binding.pbm.profile.ResourceType;
import com.vmware.vim.binding.pbm.profile.ResourceTypeEnum;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CapabilityBasedProfileRetriever
implements DataRetriever<CapabilityBasedProfile> {
    private static final Log log = LogFactory.getLog(CapabilityBasedProfileRetriever.class);
    private final PbmServiceClient _pbmClient;

    public CapabilityBasedProfileRetriever(SpbmCollectorContext collectorContext) {
        this._pbmClient = collectorContext.getPbmServiceClient();
    }

    @Override
    public List<CapabilityBasedProfile> retrieveData() {
        List<CapabilityBasedProfile> capabilityBasedProfile = Collections.emptyList();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating ProfileManager stub to retrieve CapabilityBasedProfile");
            }
            ProfileManager profileManager = this._pbmClient.getProfileManager();
            BlockingFuture futureForProfileId = new BlockingFuture();
            ResourceType resourceType = new ResourceType();
            resourceType.setResourceType(ResourceTypeEnum.STORAGE.toString());
            profileManager.queryProfile(resourceType, null, (Future)futureForProfileId);
            ProfileId[] profileIds = (ProfileId[])futureForProfileId.get();
            if (profileIds != null) {
                BlockingFuture futureForProfile = new BlockingFuture();
                profileManager.retrieveContent(profileIds, (Future)futureForProfile);
                Profile[] profiles = (Profile[])futureForProfile.get();
                if (profiles != null) {
                    capabilityBasedProfile = new ArrayList<CapabilityBasedProfile>(profiles.length);
                    for (Profile profile : profiles) {
                        capabilityBasedProfile.add((CapabilityBasedProfile)profile);
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"No capability profiles in the environment.");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn((Object)"Error occured while retrieving CapabilityBasedProfile using ProfileManager.retrieveContent() API", (Throwable)e);
        }
        return capabilityBasedProfile;
    }

    @Override
    public String getKey(CapabilityBasedProfile t) {
        return t.getProfileId().getUniqueId();
    }
}

