/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.spbm.collector.dataretriever;

import com.vmware.cis.data.api.Query;
import com.vmware.ph.phservice.provider.common.DataRetriever;
import com.vmware.ph.phservice.provider.spbm.collector.SpbmCollectorContext;
import com.vmware.ph.phservice.provider.spbm.collector.dataretriever.CapabilityBasedProfileRetriever;
import com.vmware.ph.phservice.provider.spbm.collector.dataretriever.CapabilityObjectMetadataPerCategoryRetriever;
import com.vmware.ph.phservice.provider.spbm.collector.dataretriever.CapabilityObjectSchemaRetriever;
import com.vmware.ph.phservice.provider.spbm.collector.dataretriever.CustomFaultDomainInfoRetriever;
import com.vmware.ph.phservice.provider.spbm.collector.dataretriever.DatastoreDrpRetriever;
import com.vmware.ph.phservice.provider.spbm.collector.dataretriever.FcdComplianceResultRetriever;
import com.vmware.ph.phservice.provider.spbm.collector.dataretriever.QueryReplicationGroupResultRetriever;
import com.vmware.ph.phservice.provider.spbm.collector.dataretriever.RollupComplianceResultRetriever;
import com.vmware.ph.phservice.provider.spbm.collector.dataretriever.StorageContainerRetriever;
import com.vmware.ph.phservice.provider.spbm.collector.dataretriever.VasaProviderInfoRetriever;

public class DataRetrieverFactory {
    public static DataRetriever getDataRetreiver(SpbmCollectorContext ctx, Query query) {
        String dataObjectName;
        switch (dataObjectName = (String)query.getResourceModels().iterator().next()) {
            case "CapabilityObjectSchema": {
                return new CapabilityObjectSchemaRetriever(ctx);
            }
            case "CapabilityBasedProfile": {
                return new CapabilityBasedProfileRetriever(ctx);
            }
            case "ComplianceResult": {
                return new FcdComplianceResultRetriever(ctx, query.getOffset(), query.getLimit());
            }
            case "StorageContainer": {
                return new StorageContainerRetriever(ctx);
            }
            case "RollupComplianceResult": {
                return new RollupComplianceResultRetriever(ctx, query.getOffset(), query.getLimit());
            }
            case "QueryReplicationGroupResult": {
                return new QueryReplicationGroupResultRetriever(ctx);
            }
            case "CapabilityObjectMetadataPerCategory": {
                return new CapabilityObjectMetadataPerCategoryRetriever(ctx);
            }
            case "VasaProviderInfo": {
                return new VasaProviderInfoRetriever(ctx);
            }
            case "DefaultProfileInfo": {
                return new DatastoreDrpRetriever(ctx);
            }
            case "CustomFaultDomainInfo": {
                return new CustomFaultDomainInfoRetriever(ctx);
            }
        }
        throw new UnsupportedOperationException("DataObject unknown to SPBM DataProvider: " + dataObjectName);
    }
}

