/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.spbm.collector.dataretriever;

import com.vmware.ph.phservice.provider.common.DataRetriever;
import com.vmware.ph.phservice.provider.spbm.client.pbm.PbmServiceClient;
import com.vmware.ph.phservice.provider.spbm.collector.SpbmCollectorContext;
import com.vmware.ph.phservice.provider.spbm.collector.util.SpbmUtil;
import com.vmware.ph.phservice.provider.vimcommon.vc.util.VirtualMachineReader;
import com.vmware.vim.binding.pbm.ServerObjectRef;
import com.vmware.vim.binding.pbm.compliance.ComplianceManager;
import com.vmware.vim.binding.pbm.compliance.RollupComplianceResult;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RollupComplianceResultRetriever
implements DataRetriever<RollupComplianceResult> {
    private static final Log log = LogFactory.getLog(RollupComplianceResultRetriever.class);
    private final PbmServiceClient _pbmClient;
    private final int _queryOffset;
    private final int _queryLimit;

    public RollupComplianceResultRetriever(SpbmCollectorContext collectorContext, int queryOffest, int queryLimit) {
        this._pbmClient = collectorContext.getPbmServiceClient();
        this._queryOffset = queryOffest;
        this._queryLimit = queryLimit;
    }

    @Override
    public List<RollupComplianceResult> retrieveData() {
        List<ManagedObjectReference> vmMoRefs = VirtualMachineReader.getVmMoRefs(this._pbmClient.getVcClient(), this._queryOffset, this._queryLimit);
        ArrayList<RollupComplianceResult> rollupComplianceResults = new ArrayList<RollupComplianceResult>(vmMoRefs.size());
        String vcUuid = this._pbmClient.getVcClient().getServiceInstanceContent().getAbout().getInstanceUuid();
        if (!vmMoRefs.isEmpty()) {
            ServerObjectRef[] serverObjectRefs = SpbmUtil.createSoRefsForVms(vmMoRefs);
            rollupComplianceResults.addAll(this.getRollupComplianceResult(serverObjectRefs));
            List<String> vmIdsWithNoComplianceResult = this.getVmIdsNotInRollupComplianceResultList(vmMoRefs, rollupComplianceResults);
            List<RollupComplianceResult> dummyRollupComplianceResults = this.createDummyComplianceResultsForVms(vcUuid, vmIdsWithNoComplianceResult);
            rollupComplianceResults.addAll(dummyRollupComplianceResults);
        } else {
            log.warn((Object)"No VMs in the setup!");
        }
        return rollupComplianceResults;
    }

    private List<RollupComplianceResult> getRollupComplianceResult(ServerObjectRef[] entities) {
        List<RollupComplianceResult> rollupcomplianceResultList = Collections.emptyList();
        try {
            ComplianceManager complianceManager = (ComplianceManager)this._pbmClient.createStub(this._pbmClient.getServiceInstanceContent().getComplianceManager());
            BlockingFuture futureForComplianceResult = new BlockingFuture();
            complianceManager.fetchRollupComplianceResult(entities, (Future)futureForComplianceResult);
            RollupComplianceResult[] rollupComplianceResult = (RollupComplianceResult[])futureForComplianceResult.get();
            if (rollupComplianceResult != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Retrieved ComplianceResult.");
                }
                rollupcomplianceResultList = Arrays.asList(rollupComplianceResult);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn((Object)"Error occured while retrieving ComplianceResult using ProfileManager.fetchComplianceResult() API", (Throwable)e);
        }
        return rollupcomplianceResultList;
    }

    private List<String> getVmIdsNotInRollupComplianceResultList(List<ManagedObjectReference> vmMoRefs, List<RollupComplianceResult> rollupComplianceResult) {
        List<String> vmIds = new ArrayList<String>(vmMoRefs.size());
        for (ManagedObjectReference vmMor : vmMoRefs) {
            vmIds.add(vmMor.getValue());
        }
        if (!rollupComplianceResult.isEmpty()) {
            if (rollupComplianceResult.size() != vmMoRefs.size()) {
                for (RollupComplianceResult result : rollupComplianceResult) {
                    vmIds.remove(result.getEntity().getKey());
                }
            } else {
                vmIds = Collections.emptyList();
            }
        }
        return vmIds;
    }

    private List<RollupComplianceResult> createDummyComplianceResultsForVms(String vcUuid, List<String> vmIds) {
        List<RollupComplianceResult> rollupComplianceResultsWithNullComplianceResult = Collections.emptyList();
        if (!vmIds.isEmpty()) {
            List<ServerObjectRef> vmSorList = SpbmUtil.createSorListForVm(vcUuid, vmIds);
            rollupComplianceResultsWithNullComplianceResult = SpbmUtil.createRollupComplianceResultWithNullComplianceResult(vmSorList);
        }
        return rollupComplianceResultsWithNullComplianceResult;
    }

    @Override
    public String getKey(RollupComplianceResult t) {
        return t.getEntity().getKey();
    }
}

