/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.spbm.collector.schema;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.ph.phservice.provider.vimcommon.VmodlTypeToQuerySchemaModelInfoConverter;
import com.vmware.ph.phservice.provider.vimcommon.VmodlUtil;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpbmCustomObjectSchemaGenerator {
    private static final Log log = LogFactory.getLog(SpbmCustomObjectSchemaGenerator.class);
    private final Set<Class<?>> _schemaClasses;
    private final VmodlTypeMap _vmodlTypeMap;
    private final VmodlVersion _vmodlVersion;

    public SpbmCustomObjectSchemaGenerator(VmodlTypeMap vmodlTypeMap, VmodlVersion vmodlVersion, Set<Class<?>> schemaClasses) {
        this._vmodlTypeMap = vmodlTypeMap;
        this._schemaClasses = schemaClasses;
        this._vmodlVersion = vmodlVersion;
    }

    public Map<String, QuerySchema.ModelInfo> getQuerySchemaModel() {
        HashMap<String, QuerySchema.ModelInfo> models = new HashMap<String, QuerySchema.ModelInfo>();
        for (Class<?> clazz : this._schemaClasses) {
            models.putAll(this.getModel(clazz.getName()));
        }
        return models;
    }

    private Map<String, QuerySchema.ModelInfo> getModel(String modelName) {
        String typeName = SpbmCustomObjectSchemaGenerator.getPropertyName(modelName);
        List<String> propertyNames = this.getPropertyNamesForCustomClass(modelName);
        HashMap<String, QuerySchema.ModelInfo> model = new HashMap<String, QuerySchema.ModelInfo>();
        model.put(typeName, VmodlTypeToQuerySchemaModelInfoConverter.convertPropertyNamesToModelInfo(propertyNames));
        return model;
    }

    private List<String> getPropertyNamesForCustomClass(String modelName) {
        try {
            Class<?> clazz = Class.forName(modelName);
            return this.getPropertyNamesInClass(clazz);
        }
        catch (ClassNotFoundException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Class " + modelName + " not found."), (Throwable)e);
            }
            return Collections.emptyList();
        }
    }

    private List<String> getPropertyNamesInClass(Class<?> clazz) {
        HashSet<String> propertyNames = new HashSet<String>();
        for (Field field : clazz.getFields()) {
            propertyNames.add(SpbmCustomObjectSchemaGenerator.getPropertyName(field.toString()));
        }
        for (VmodlType vmodlType : this._vmodlTypeMap.getVmodlTypes()) {
            if (!vmodlType.getTypeClass().isAssignableFrom(clazz)) continue;
            propertyNames.addAll(VmodlUtil.getProperties(vmodlType, 4, this._vmodlTypeMap, this._vmodlVersion));
        }
        return new ArrayList<String>(propertyNames);
    }

    private static String getPropertyName(String fieldName) {
        String[] arr = fieldName.split(Pattern.quote("."));
        if (arr != null && arr.length > 0) {
            return arr[arr.length - 1];
        }
        return null;
    }
}

