/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.system.monitor;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.ph.phservice.provider.common.QuerySchemaUtil;
import com.vmware.ph.phservice.provider.system.monitor.SystemLoadMonitor;
import com.vmware.ph.phservice.provider.system.monitor.SystemLoadMonitorException;
import com.vmware.ph.phservice.provider.vimcommon.VmodlTypeToQuerySchemaModelInfoConverter;
import com.vmware.ph.phservice.provider.vimcommon.util.VimDataProviderUtil;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemLoadDataProvider
implements DataProvider {
    private static final Log _log = LogFactory.getLog(SystemLoadDataProvider.class);
    private static final String QUALIFYING_SYMBOL_PLACEHOLDER = "_";
    private static final String QUALIFYING_SYMBOL = ".";
    private static final String QUALIFYING_SYMBOL_REGEX = "\\.";
    private static final String RESOURCE_MODEL_NAME = "SystemLoad";
    static final String INTERVAL_MINUTES_PROPERTY = "intervalMinutes";
    private static final Set<String> MONITORED_ITEMS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("cpu.util", "mem.util", "mem.total")));
    private final VcClient _vcClient;
    private final SystemLoadMonitor _systemLoadMonitor;

    public SystemLoadDataProvider(VcClient vcClient, SystemLoadMonitor systemLoadMonitor) {
        this._vcClient = vcClient;
        this._systemLoadMonitor = systemLoadMonitor;
    }

    public QuerySchema getSchema() {
        List<String> queryProperties = SystemLoadDataProvider.getQueryPropertyNames(MONITORED_ITEMS);
        queryProperties.add(INTERVAL_MINUTES_PROPERTY);
        QuerySchema.ModelInfo modelInfo = VmodlTypeToQuerySchemaModelInfoConverter.convertPropertyNamesToModelInfo(queryProperties);
        Map<String, QuerySchema.ModelInfo> modelInfoByModelName = Collections.singletonMap(RESOURCE_MODEL_NAME, modelInfo);
        return QuerySchema.forModels(modelInfoByModelName);
    }

    public ResultSet executeQuery(Query query) {
        ResultSet.Builder resultBuilder;
        block2: {
            List queryProperties = query.getProperties();
            String vcInstanceUuid = this._vcClient.getServiceInstanceContent().getAbout().getInstanceUuid();
            URI modelKey = VimDataProviderUtil.createModelKey(RESOURCE_MODEL_NAME, vcInstanceUuid);
            int intervalMinutes = SystemLoadDataProvider.getIntervalMinutesFromFilter(query.getFilter());
            resultBuilder = ResultSet.Builder.properties((List)queryProperties);
            try {
                List<Object> monitoredItemsData = this.getMonitoredItemsData(queryProperties, intervalMinutes);
                monitoredItemsData.add(0, modelKey);
                resultBuilder.item((Object)modelKey, monitoredItemsData);
            }
            catch (SystemLoadMonitorException e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)"Could not collect system load data. Will return empty result", (Throwable)e);
            }
        }
        return resultBuilder.build();
    }

    private static int getIntervalMinutesFromFilter(Filter filter) {
        if (filter == null || filter.getCriteria().isEmpty()) {
            throw new IllegalArgumentException("Missing required filter in query");
        }
        if (filter.getCriteria().size() > 1) {
            throw new IllegalArgumentException("Filtering by more than 1 property not supported at this time");
        }
        PropertyPredicate predicate = (PropertyPredicate)filter.getCriteria().iterator().next();
        if (predicate.getOperator() != PropertyPredicate.ComparisonOperator.EQUAL) {
            throw new IllegalArgumentException("Comparison operator [" + predicate.getOperator() + "] is not supported at this time");
        }
        String nonQualifiedPropertyName = QuerySchemaUtil.getActualPropertyName(predicate.getProperty());
        if (!INTERVAL_MINUTES_PROPERTY.equals(nonQualifiedPropertyName)) {
            throw new IllegalArgumentException("Filtering by property [" + nonQualifiedPropertyName + "] is not supported");
        }
        String propertyValue = (String)predicate.getComparableValue();
        return Integer.parseInt(propertyValue);
    }

    private List<Object> getMonitoredItemsData(List<String> queryProperties, int intervalMinutes) throws SystemLoadMonitorException {
        LinkedList<Object> propertyValues = new LinkedList<Object>();
        List<String> monitoredItemNames = SystemLoadDataProvider.getMonitoredItemNames(queryProperties);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("Retrieving load data for the last [%d] minutes for monitored items %s.", intervalMinutes, monitoredItemNames));
        }
        Map<String, Double> monitoredItemsData = this._systemLoadMonitor.getAverageValuesForMonitoredItems(monitoredItemNames, intervalMinutes);
        for (String monitoredItemName : monitoredItemNames) {
            propertyValues.add(monitoredItemsData.get(monitoredItemName));
        }
        return propertyValues;
    }

    private static List<String> getMonitoredItemNames(List<String> queryProperties) {
        List<String> nonQualifiedQueryProperties = QuerySchemaUtil.getNonQualifiedPropertyNames(queryProperties);
        ArrayList<String> monitoredItemNames = new ArrayList<String>(queryProperties.size() - 1);
        for (String property : nonQualifiedQueryProperties) {
            if (QuerySchemaUtil.isQueryPropertyModelKey(property)) continue;
            String monitoredItemName = SystemLoadDataProvider.getMonitoredItemName(property);
            monitoredItemNames.add(monitoredItemName);
        }
        return monitoredItemNames;
    }

    private static List<String> getQueryPropertyNames(Set<String> monitorItemsNames) {
        ArrayList<String> propertyNames = new ArrayList<String>(monitorItemsNames.size());
        for (String property : monitorItemsNames) {
            String propertyName = SystemLoadDataProvider.getQueryPropertyName(property);
            propertyNames.add(propertyName);
        }
        return propertyNames;
    }

    private static String getQueryPropertyName(String monitorItemName) {
        return monitorItemName.replaceAll(QUALIFYING_SYMBOL_REGEX, QUALIFYING_SYMBOL_PLACEHOLDER);
    }

    private static String getMonitoredItemName(String queryProperty) {
        return queryProperty.replaceAll(QUALIFYING_SYMBOL_PLACEHOLDER, QUALIFYING_SYMBOL);
    }
}

