/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.system.monitor.impl;

import com.vmware.ph.phservice.provider.system.monitor.SystemLoadMonitor;
import com.vmware.ph.phservice.provider.system.monitor.SystemLoadMonitorException;
import com.vmware.ph.phservice.provider.system.monitor.impl.NativeLibraryLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;

public class SigarLocalSystemLoadMonitor
implements SystemLoadMonitor {
    private static final Log _log = LogFactory.getLog(SigarLocalSystemLoadMonitor.class);
    private static final int DEFAULT_NUMBER_OF_SAMPLES = 30;
    private static final String LIB_LIBSIGAR_AMD64_LINUX_SO = "/lib/libsigar-amd64-linux.so";
    private static final String LIB_SIGAR_AMD64_WINNT_DLL = "/lib/sigar-amd64-winnt.dll";
    private static boolean isSigarLoaded = false;
    private final int _numberOfSamples;
    private final NativeLibraryLoader _nativeLibLoader;
    private final SigarFactory _sigarFactory;
    private final SystemUtilWrapper _systemUtilWrapper;
    private final ThreadSleepWrapper _threadSleepWrapper;
    private final Map<Integer, AveragedSystemLoad> _averageSystemLoadPerInterval = new HashMap<Integer, AveragedSystemLoad>();

    public SigarLocalSystemLoadMonitor() {
        this(30, new NativeLibraryLoader(), new SigarFactory(), new SystemUtilWrapper(), new ThreadSleepWrapper());
    }

    SigarLocalSystemLoadMonitor(int numberOfSamples, NativeLibraryLoader nativeLibLoader, SigarFactory sigarFactory, SystemUtilWrapper systemUtilWrapper, ThreadSleepWrapper threadSleepWrapper) {
        this._numberOfSamples = numberOfSamples;
        this._nativeLibLoader = nativeLibLoader;
        this._sigarFactory = sigarFactory;
        this._systemUtilWrapper = systemUtilWrapper;
        this._threadSleepWrapper = threadSleepWrapper;
    }

    @Override
    public Map<String, Double> getAverageValuesForMonitoredItems(List<String> monitoredItemNames, int lastXMinutes) throws SystemLoadMonitorException {
        this.calculateAverageSystemLoadForIntervalOnce(lastXMinutes);
        AveragedSystemLoad averageSystemLoadForInterval = this._averageSystemLoadPerInterval.get(lastXMinutes);
        return SigarLocalSystemLoadMonitor.createMonitoredItemsData(monitoredItemNames, averageSystemLoadForInterval);
    }

    private synchronized void calculateAverageSystemLoadForIntervalOnce(int lastXMinutes) throws SystemLoadMonitorException {
        boolean isAlreadyCalculatedForInterval = this._averageSystemLoadPerInterval.containsKey(lastXMinutes);
        if (isAlreadyCalculatedForInterval) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Average system load for the last [" + lastXMinutes + "] minutes already calculated."));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Calculating average system load for the last [" + lastXMinutes + "] minutes"));
        }
        AveragedSystemLoad averagedSystemLoad = this.calculateAverageSystemLoad(lastXMinutes);
        this._averageSystemLoadPerInterval.put(lastXMinutes, averagedSystemLoad);
    }

    private AveragedSystemLoad calculateAverageSystemLoad(int lastXMinutes) throws SystemLoadMonitorException {
        try {
            this.loadSigarNativeLib();
            SigarProxy sigar = this._sigarFactory.createSigarProxy();
            long lastXMinutesInMillis = TimeUnit.MILLISECONDS.convert(lastXMinutes, TimeUnit.MINUTES);
            long sleepIntervalMillis = lastXMinutesInMillis / (long)this._numberOfSamples;
            AveragedSystemLoad averagedSystemLoad = new AveragedSystemLoad();
            for (int i = 1; i <= this._numberOfSamples; ++i) {
                Mem mem = sigar.getMem();
                CpuPerc cpuPerc = sigar.getCpuPerc();
                double currentUsedCPUPerc = cpuPerc.getCombined() * 100.0;
                double currentUsedMemKb = mem.getUsed();
                averagedSystemLoad.usedCPUPerc = SigarLocalSystemLoadMonitor.getAverage(averagedSystemLoad.usedCPUPerc, currentUsedCPUPerc, i);
                averagedSystemLoad.usedMemKb = SigarLocalSystemLoadMonitor.getAverage(averagedSystemLoad.usedMemKb, currentUsedMemKb, i);
                if (averagedSystemLoad.totalMemKb <= 0.0) {
                    averagedSystemLoad.totalMemKb = mem.getTotal();
                }
                if (i >= this._numberOfSamples || !_log.isDebugEnabled()) continue;
                _log.debug((Object)("Sleeping for " + sleepIntervalMillis + " milliseconds on iteration " + i + " from " + this._numberOfSamples));
                this._threadSleepWrapper.sleep(sleepIntervalMillis);
            }
            this._sigarFactory.clearSigarProxyCache(sigar);
            return averagedSystemLoad;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SystemLoadMonitorException(e);
        }
        catch (Exception e) {
            throw new SystemLoadMonitorException(e);
        }
    }

    private static Map<String, Double> createMonitoredItemsData(List<String> monitoredItemNames, AveragedSystemLoad averageSystemLoad) {
        HashMap<String, Double> averageMonitoredData = new HashMap<String, Double>();
        Iterator<String> i$ = monitoredItemNames.iterator();
        block10: while (i$.hasNext()) {
            String monitoredItem;
            switch (monitoredItem = i$.next()) {
                case "cpu.util": {
                    averageMonitoredData.put("cpu.util", averageSystemLoad.usedCPUPerc);
                    continue block10;
                }
                case "mem.util": {
                    averageMonitoredData.put("mem.util", averageSystemLoad.usedMemKb);
                    continue block10;
                }
                case "mem.total": {
                    averageMonitoredData.put("mem.total", averageSystemLoad.totalMemKb);
                    continue block10;
                }
            }
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("Monitoring item not supported: " + monitoredItem));
        }
        return averageMonitoredData;
    }

    private static double getAverage(double currentAvg, double newValue, int numbersSoFar) {
        return ((double)(numbersSoFar - 1) * currentAvg + newValue) / (double)numbersSoFar;
    }

    private synchronized void loadSigarNativeLib() throws NativeLibraryLoader.NativeLibraryLoaderException {
        if (!isSigarLoaded) {
            if (this._systemUtilWrapper.isWindows()) {
                this._nativeLibLoader.loadLibraryFromJar(LIB_SIGAR_AMD64_WINNT_DLL);
            } else {
                this._nativeLibLoader.loadLibraryFromJar(LIB_LIBSIGAR_AMD64_LINUX_SO);
            }
            isSigarLoaded = true;
        }
    }

    static class ThreadSleepWrapper {
        ThreadSleepWrapper() {
        }

        public void sleep(long sleepIntervalMillis) throws InterruptedException {
            Thread.sleep(sleepIntervalMillis);
        }
    }

    static class SystemUtilWrapper {
        SystemUtilWrapper() {
        }

        public boolean isWindows() {
            return SystemUtils.IS_OS_WINDOWS;
        }
    }

    static class SigarFactory {
        private static final int SIGAR_PROXY_PERIOD_MILLIS = 3000;

        SigarFactory() {
        }

        public SigarProxy createSigarProxy() {
            Sigar sigarImpl = new Sigar();
            SigarProxy sigar = SigarProxyCache.newInstance(sigarImpl, 3000);
            return sigar;
        }

        public void clearSigarProxyCache(SigarProxy sigar) {
            SigarProxyCache.clear(sigar);
        }
    }

    private static class AveragedSystemLoad {
        private double usedCPUPerc = 0.0;
        private double usedMemKb = 0.0;
        private double totalMemKb = 0.0;

        private AveragedSystemLoad() {
        }
    }
}

