/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vcenter.alarms;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.ph.phservice.provider.common.PageUtil;
import com.vmware.ph.phservice.provider.vimcommon.VmodlTypeToQuerySchemaModelInfoConverter;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.ph.phservice.provider.vimcommon.vc.pc.PcDataProviderUtil;
import com.vmware.ph.phservice.provider.vimcommon.vc.pc.PropertyCollectorReader;
import com.vmware.ph.phservice.provider.vimcommon.vc.pc.PropertyCollectorUtil;
import com.vmware.vim.binding.vim.alarm.AlarmManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.InvalidProperty;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmsDataProviderImpl
implements DataProvider {
    private static final Log log = LogFactory.getLog(AlarmsDataProviderImpl.class);
    private static final String ALARM_MO_TYPE_NAME = "Alarm";
    private final VcClient _vcClient;
    private final VmodlTypeMap _vmodlTypeMap;
    private final QuerySchema _querySchema;
    private final PropertyCollectorReader _pcReader;

    public AlarmsDataProviderImpl(VcClient vcClient) {
        this._vcClient = vcClient;
        this._vmodlTypeMap = vcClient.getVmodlContext().getVmodlTypeMap();
        this._querySchema = this.initQuerySchemaForAlarms();
        this._pcReader = new PropertyCollectorReader(this._vcClient);
    }

    public ResultSet executeQuery(Query query) {
        List<String> pcPropertyNames = PcDataProviderUtil.convertQueryPropertiesToPcProperties(query.getProperties());
        List<PropertyCollectorReader.PcResourceItem> pcResourceItems = this.collectAlarms(pcPropertyNames, query.getOffset(), query.getLimit());
        ResultSet queryResultSet = PcDataProviderUtil.convertPcResourceItemsToQueryResultSet(query.getProperties(), pcResourceItems);
        return queryResultSet;
    }

    public QuerySchema getSchema() {
        return this._querySchema;
    }

    private List<PropertyCollectorReader.PcResourceItem> collectAlarms(List<String> pcPropertyNames, int queryOffset, int queryLimit) {
        AlarmManager manager = this.fetchAlarmManager();
        if (manager == null) {
            return null;
        }
        if (queryLimit == 0) {
            return null;
        }
        ManagedObjectReference[] alarms = manager.getAlarm(null);
        if (alarms == null || alarms.length == 0) {
            return null;
        }
        List<ManagedObjectReference> alarmMoRefs = Arrays.asList(alarms);
        if (queryLimit != -1) {
            alarmMoRefs = PageUtil.pageItems(alarmMoRefs, queryOffset, queryLimit);
        }
        PropertyCollector.FilterSpec pcFilterSpec = PropertyCollectorUtil.createMoRefsFilterSpec(alarmMoRefs.toArray(new ManagedObjectReference[alarmMoRefs.size()]), pcPropertyNames, this._vmodlTypeMap);
        try {
            List<PropertyCollectorReader.PcResourceItem> pcResourceItems = this._pcReader.retrieveContent(pcFilterSpec, pcPropertyNames, 0, -1);
            return pcResourceItems;
        }
        catch (InvalidProperty ip) {
            log.warn((Object)ip.getMessage());
            return null;
        }
    }

    private QuerySchema initQuerySchemaForAlarms() {
        Map<String, QuerySchema.ModelInfo> models = VmodlTypeToQuerySchemaModelInfoConverter.convertVmodlTypesToWsdlNameModelInfos(Collections.singletonList(this._vmodlTypeMap.getVmodlType(ALARM_MO_TYPE_NAME)), this._vmodlTypeMap, this._vcClient.getVmodlVersion());
        return QuerySchema.forModels(models);
    }

    private AlarmManager fetchAlarmManager() {
        return (AlarmManager)this._vcClient.createMo(this._vcClient.getServiceInstanceContent().alarmManager);
    }
}

