/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.provider.vcenter.event;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.ph.phservice.provider.common.QuerySchemaUtil;
import com.vmware.vim.binding.vim.event.EventFilterSpec;
import java.util.Calendar;
import java.util.TimeZone;

public class QueryFilterToEventFilterSpecConverter {
    private static final int EVENT_HISTORY_COLLECTOR_MAX_PAGE_SIZE = 1000;
    private static final int DEFAULT_DAYS_EVENT_OFFSET = -7;
    private static final String EVENT_TYPE_ID_PROPERTY = "eventTypeId";
    private static final String SEVERITY_PROPERTY = "severity";
    private static final String CREATED_TIME_PROPERTY = "createdTime";
    private static final String VIM_EVENT_TYPE_ID_PREFIX = "vim.event.";

    public EventFilterSpec createEventFilterSpec(String eventsTypeName, Filter queryFilter) {
        EventFilterSpec eventFilterSpec = new EventFilterSpec();
        eventFilterSpec.setMaxCount(Integer.valueOf(1000));
        eventFilterSpec.setDisableFullMessage(Boolean.valueOf(true));
        QueryFilterToEventFilterSpecConverter.updateEventFilterSpecEventTypeId(eventFilterSpec, eventsTypeName);
        QueryFilterToEventFilterSpecConverter.updateEventFilterSpecTime(eventFilterSpec, -7);
        if (queryFilter != null) {
            QueryFilterToEventFilterSpecConverter.updateEventFilterSpecFromQueryFilterProperties(eventFilterSpec, queryFilter);
        }
        return eventFilterSpec;
    }

    private static void updateEventFilterSpecEventTypeId(EventFilterSpec eventFilterSpec, String eventsTypeName) {
        String eventTypeId = VIM_EVENT_TYPE_ID_PREFIX + eventsTypeName;
        eventFilterSpec.setEventTypeId(new String[]{eventTypeId});
    }

    private static void updateEventFilterSpecTime(EventFilterSpec eventFilterSpec, int daysEventOffset) {
        Calendar startTime = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        startTime.add(5, daysEventOffset);
        Calendar endTime = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        eventFilterSpec.setTime(new EventFilterSpec.ByTime(startTime, endTime));
    }

    private static void updateEventFilterSpecFromQueryFilterProperties(EventFilterSpec eventFilterSpec, Filter queryFilter) {
        boolean isEventTypeIdPredicateEvaluated = false;
        boolean isSeverityPredicateEvaluated = false;
        boolean isCreatedTimePredicateEvaluated = false;
        for (PropertyPredicate eventQueryPredicate : queryFilter.getCriteria()) {
            String nonQualifiedPropertyName;
            switch (nonQualifiedPropertyName = QuerySchemaUtil.getActualPropertyName(eventQueryPredicate.getProperty())) {
                case "eventTypeId": {
                    if (isEventTypeIdPredicateEvaluated) break;
                    QueryFilterToEventFilterSpecConverter.updateEventFilterSpecEventTypeIdFromPredicate(eventFilterSpec, eventQueryPredicate);
                    isEventTypeIdPredicateEvaluated = true;
                    break;
                }
                case "severity": {
                    if (isSeverityPredicateEvaluated) break;
                    QueryFilterToEventFilterSpecConverter.updateEventFilterSpecCategoryFromPredicate(eventFilterSpec, eventQueryPredicate);
                    isSeverityPredicateEvaluated = true;
                    break;
                }
                case "createdTime": {
                    if (isCreatedTimePredicateEvaluated) break;
                    QueryFilterToEventFilterSpecConverter.updateEventFilterSpecTimeFromPredicate(eventFilterSpec, eventQueryPredicate);
                    isCreatedTimePredicateEvaluated = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Filtering events by %s property is not supported.", nonQualifiedPropertyName));
                }
            }
            if (queryFilter.getOperator() != LogicalOperator.OR) continue;
            break;
        }
    }

    private static void updateEventFilterSpecEventTypeIdFromPredicate(EventFilterSpec eventFilterSpec, PropertyPredicate eventTypeIdPredicate) {
        String eventTypeId = (String)QueryFilterToEventFilterSpecConverter.evaluatePropertyPredicateValue(eventTypeIdPredicate);
        if (eventTypeId != null) {
            eventFilterSpec.setEventTypeId(new String[]{eventTypeId});
        }
    }

    private static void updateEventFilterSpecCategoryFromPredicate(EventFilterSpec eventFilterSpec, PropertyPredicate severityPredicate) {
        String severity = (String)QueryFilterToEventFilterSpecConverter.evaluatePropertyPredicateValue(severityPredicate);
        if (severity != null) {
            eventFilterSpec.setCategory(new String[]{severity});
        }
    }

    private static void updateEventFilterSpecTimeFromPredicate(EventFilterSpec eventFilterSpec, PropertyPredicate createdTimePredicate) {
        String createdTime = (String)QueryFilterToEventFilterSpecConverter.evaluatePropertyPredicateTimeValue(createdTimePredicate);
        if (createdTime != null) {
            QueryFilterToEventFilterSpecConverter.updateEventFilterSpecTime(eventFilterSpec, Integer.parseInt(createdTime));
        }
    }

    private static Object evaluatePropertyPredicateValue(PropertyPredicate propertyPredicate) {
        PropertyPredicate.ComparisonOperator comparisonOperator = propertyPredicate.getOperator();
        if (comparisonOperator != PropertyPredicate.ComparisonOperator.EQUAL) {
            return null;
        }
        return propertyPredicate.getComparableValue();
    }

    private static Object evaluatePropertyPredicateTimeValue(PropertyPredicate propertyPredicate) {
        PropertyPredicate.ComparisonOperator comparisonOperator = propertyPredicate.getOperator();
        if (comparisonOperator != PropertyPredicate.ComparisonOperator.GREATER_OR_EQUAL) {
            return null;
        }
        return propertyPredicate.getComparableValue();
    }
}

